/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v1.flow;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v1.flow.Engagement;

public class EngagementReader
extends Reader<Engagement> {
    private String pathFlowSid;
    private Integer pageSize;

    public EngagementReader(String pathFlowSid) {
        this.pathFlowSid = pathFlowSid;
    }

    public EngagementReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Engagement> read(TwilioRestClient client) {
        return new ResourceSet<Engagement>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Engagement> firstPage(TwilioRestClient client) {
        String path = "/v1/Flows/{FlowSid}/Engagements";
        path = path.replace("{FlowSid}", this.pathFlowSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.STUDIO.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<Engagement> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Engagement read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("engagements", response.getContent(), Engagement.class, client.getObjectMapper());
    }

    @Override
    public Page<Engagement> previousPage(Page<Engagement> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.STUDIO.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Engagement> nextPage(Page<Engagement> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.STUDIO.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Engagement> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

