/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v1.flow;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v1.flow.Execution;
import java.time.ZonedDateTime;

public class ExecutionReader
extends Reader<Execution> {
    private String pathFlowSid;
    private ZonedDateTime dateCreatedFrom;
    private ZonedDateTime dateCreatedTo;
    private Integer pageSize;

    public ExecutionReader(String pathFlowSid) {
        this.pathFlowSid = pathFlowSid;
    }

    public ExecutionReader setDateCreatedFrom(ZonedDateTime dateCreatedFrom) {
        this.dateCreatedFrom = dateCreatedFrom;
        return this;
    }

    public ExecutionReader setDateCreatedTo(ZonedDateTime dateCreatedTo) {
        this.dateCreatedTo = dateCreatedTo;
        return this;
    }

    public ExecutionReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Execution> read(TwilioRestClient client) {
        return new ResourceSet<Execution>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Execution> firstPage(TwilioRestClient client) {
        String path = "/v1/Flows/{FlowSid}/Executions";
        path = path.replace("{FlowSid}", this.pathFlowSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.STUDIO.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<Execution> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Execution read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("executions", response.getContent(), Execution.class, client.getObjectMapper());
    }

    @Override
    public Page<Execution> previousPage(Page<Execution> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.STUDIO.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Execution> nextPage(Page<Execution> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.STUDIO.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Execution> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.dateCreatedFrom != null) {
            request.addQueryParam("DateCreatedFrom", this.dateCreatedFrom.toInstant().toString());
        }
        if (this.dateCreatedTo != null) {
            request.addQueryParam("DateCreatedTo", this.dateCreatedTo.toInstant().toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

