/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v2.flow;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v2.flow.FlowRevision;

public class FlowRevisionFetcher
extends Fetcher<FlowRevision> {
    private String pathSid;
    private String pathRevision;

    public FlowRevisionFetcher(String pathSid, String pathRevision) {
        this.pathSid = pathSid;
        this.pathRevision = pathRevision;
    }

    @Override
    public FlowRevision fetch(TwilioRestClient client) {
        String path = "/v2/Flows/{Sid}/Revisions/{Revision}";
        path = path.replace("{Sid}", this.pathSid.toString());
        path = path.replace("{Revision}", this.pathRevision.toString());
        Request request = new Request(HttpMethod.GET, Domains.STUDIO.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("FlowRevision fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return FlowRevision.fromJson(response.getStream(), client.getObjectMapper());
    }
}

