/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v2.flow.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.studio.v2.flow.execution.ExecutionStepFetcher;
import com.twilio.rest.studio.v2.flow.execution.ExecutionStepReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExecutionStep
extends Resource {
    private static final long serialVersionUID = 271983635262130L;
    private final String sid;
    private final String accountSid;
    private final String flowSid;
    private final String executionSid;
    private final String name;
    private final Map<String, Object> context;
    private final String transitionedFrom;
    private final String transitionedTo;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    public static ExecutionStepFetcher fetcher(String pathFlowSid, String pathExecutionSid, String pathSid) {
        return new ExecutionStepFetcher(pathFlowSid, pathExecutionSid, pathSid);
    }

    public static ExecutionStepReader reader(String pathFlowSid, String pathExecutionSid) {
        return new ExecutionStepReader(pathFlowSid, pathExecutionSid);
    }

    public static ExecutionStep fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ExecutionStep.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ExecutionStep fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ExecutionStep.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ExecutionStep(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="flow_sid") String flowSid, @JsonProperty(value="execution_sid") String executionSid, @JsonProperty(value="name") String name, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="transitioned_from") String transitionedFrom, @JsonProperty(value="transitioned_to") String transitionedTo, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.flowSid = flowSid;
        this.executionSid = executionSid;
        this.name = name;
        this.context = context;
        this.transitionedFrom = transitionedFrom;
        this.transitionedTo = transitionedTo;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFlowSid() {
        return this.flowSid;
    }

    public final String getExecutionSid() {
        return this.executionSid;
    }

    public final String getName() {
        return this.name;
    }

    public final Map<String, Object> getContext() {
        return this.context;
    }

    public final String getTransitionedFrom() {
        return this.transitionedFrom;
    }

    public final String getTransitionedTo() {
        return this.transitionedTo;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionStep other = (ExecutionStep)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.flowSid, other.flowSid) && Objects.equals(this.executionSid, other.executionSid) && Objects.equals(this.name, other.name) && Objects.equals(this.context, other.context) && Objects.equals(this.transitionedFrom, other.transitionedFrom) && Objects.equals(this.transitionedTo, other.transitionedTo) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.flowSid, this.executionSid, this.name, this.context, this.transitionedFrom, this.transitionedTo, this.dateCreated, this.dateUpdated, this.url, this.links);
    }

    public String toString() {
        return "ExecutionStep(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", flowSid=" + this.getFlowSid() + ", executionSid=" + this.getExecutionSid() + ", name=" + this.getName() + ", context=" + this.getContext() + ", transitionedFrom=" + this.getTransitionedFrom() + ", transitionedTo=" + this.getTransitionedTo() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ")";
    }
}

