/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.supersim.v1.EsimProfileCreator;
import com.twilio.rest.supersim.v1.EsimProfileFetcher;
import com.twilio.rest.supersim.v1.EsimProfileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EsimProfile
extends Resource {
    private static final long serialVersionUID = 165735118410901L;
    private final String sid;
    private final String accountSid;
    private final String iccid;
    private final String simSid;
    private final Status status;
    private final String eid;
    private final URI smdpPlusAddress;
    private final String matchingId;
    private final String activationCode;
    private final String errorCode;
    private final String errorMessage;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    public static EsimProfileCreator creator() {
        return new EsimProfileCreator();
    }

    public static EsimProfileFetcher fetcher(String pathSid) {
        return new EsimProfileFetcher(pathSid);
    }

    public static EsimProfileReader reader() {
        return new EsimProfileReader();
    }

    public static EsimProfile fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, EsimProfile.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static EsimProfile fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, EsimProfile.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private EsimProfile(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="iccid") String iccid, @JsonProperty(value="sim_sid") String simSid, @JsonProperty(value="status") Status status, @JsonProperty(value="eid") String eid, @JsonProperty(value="smdp_plus_address") URI smdpPlusAddress, @JsonProperty(value="matching_id") String matchingId, @JsonProperty(value="activation_code") String activationCode, @JsonProperty(value="error_code") String errorCode, @JsonProperty(value="error_message") String errorMessage, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.iccid = iccid;
        this.simSid = simSid;
        this.status = status;
        this.eid = eid;
        this.smdpPlusAddress = smdpPlusAddress;
        this.matchingId = matchingId;
        this.activationCode = activationCode;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getIccid() {
        return this.iccid;
    }

    public final String getSimSid() {
        return this.simSid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getEid() {
        return this.eid;
    }

    public final URI getSmdpPlusAddress() {
        return this.smdpPlusAddress;
    }

    public final String getMatchingId() {
        return this.matchingId;
    }

    public final String getActivationCode() {
        return this.activationCode;
    }

    public final String getErrorCode() {
        return this.errorCode;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EsimProfile other = (EsimProfile)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.iccid, other.iccid) && Objects.equals(this.simSid, other.simSid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.eid, other.eid) && Objects.equals(this.smdpPlusAddress, other.smdpPlusAddress) && Objects.equals(this.matchingId, other.matchingId) && Objects.equals(this.activationCode, other.activationCode) && Objects.equals(this.errorCode, other.errorCode) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.iccid, this.simSid, this.status, this.eid, this.smdpPlusAddress, this.matchingId, this.activationCode, this.errorCode, this.errorMessage, this.dateCreated, this.dateUpdated, this.url});
    }

    public String toString() {
        return "EsimProfile(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", iccid=" + this.getIccid() + ", simSid=" + this.getSimSid() + ", status=" + (Object)((Object)this.getStatus()) + ", eid=" + this.getEid() + ", smdpPlusAddress=" + this.getSmdpPlusAddress() + ", matchingId=" + this.getMatchingId() + ", activationCode=" + this.getActivationCode() + ", errorCode=" + this.getErrorCode() + ", errorMessage=" + this.getErrorMessage() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ")";
    }

    public static enum Status {
        NEW("new"),
        RESERVING("reserving"),
        AVAILABLE("available"),
        DOWNLOADED("downloaded"),
        INSTALLED("installed"),
        FAILED("failed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

