/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.IpCommand;
import java.net.URI;

public class IpCommandCreator
extends Creator<IpCommand> {
    private String sim;
    private String payload;
    private Integer devicePort;
    private IpCommand.PayloadType payloadType;
    private URI callbackUrl;
    private HttpMethod callbackMethod;

    public IpCommandCreator(String sim, String payload, Integer devicePort) {
        this.sim = sim;
        this.payload = payload;
        this.devicePort = devicePort;
    }

    public IpCommandCreator setSim(String sim) {
        this.sim = sim;
        return this;
    }

    public IpCommandCreator setPayload(String payload) {
        this.payload = payload;
        return this;
    }

    public IpCommandCreator setDevicePort(Integer devicePort) {
        this.devicePort = devicePort;
        return this;
    }

    public IpCommandCreator setPayloadType(IpCommand.PayloadType payloadType) {
        this.payloadType = payloadType;
        return this;
    }

    public IpCommandCreator setCallbackUrl(URI callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public IpCommandCreator setCallbackUrl(String callbackUrl) {
        return this.setCallbackUrl(Promoter.uriFromString(callbackUrl));
    }

    public IpCommandCreator setCallbackMethod(HttpMethod callbackMethod) {
        this.callbackMethod = callbackMethod;
        return this;
    }

    @Override
    public IpCommand create(TwilioRestClient client) {
        String path = "/v1/IpCommands";
        path = path.replace("{Sim}", this.sim.toString());
        path = path.replace("{Payload}", this.payload.toString());
        path = path.replace("{DevicePort}", this.devicePort.toString());
        Request request = new Request(HttpMethod.POST, Domains.SUPERSIM.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("IpCommand creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return IpCommand.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.sim != null) {
            request.addPostParam("Sim", this.sim);
        }
        if (this.payload != null) {
            request.addPostParam("Payload", this.payload);
        }
        if (this.devicePort != null) {
            request.addPostParam("DevicePort", this.devicePort.toString());
        }
        if (this.payloadType != null) {
            request.addPostParam("PayloadType", this.payloadType.toString());
        }
        if (this.callbackUrl != null) {
            request.addPostParam("CallbackUrl", this.callbackUrl.toString());
        }
        if (this.callbackMethod != null) {
            request.addPostParam("CallbackMethod", this.callbackMethod.toString());
        }
    }
}

