/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.Sim;
import java.net.URI;

public class SimUpdater
extends Updater<Sim> {
    private String pathSid;
    private String uniqueName;
    private Sim.StatusUpdate status;
    private String fleet;
    private URI callbackUrl;
    private HttpMethod callbackMethod;
    private String accountSid;

    public SimUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public SimUpdater setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public SimUpdater setStatus(Sim.StatusUpdate status) {
        this.status = status;
        return this;
    }

    public SimUpdater setFleet(String fleet) {
        this.fleet = fleet;
        return this;
    }

    public SimUpdater setCallbackUrl(URI callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public SimUpdater setCallbackUrl(String callbackUrl) {
        return this.setCallbackUrl(Promoter.uriFromString(callbackUrl));
    }

    public SimUpdater setCallbackMethod(HttpMethod callbackMethod) {
        this.callbackMethod = callbackMethod;
        return this;
    }

    public SimUpdater setAccountSid(String accountSid) {
        this.accountSid = accountSid;
        return this;
    }

    @Override
    public Sim update(TwilioRestClient client) {
        String path = "/v1/Sims/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.SUPERSIM.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Sim update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Sim.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
        if (this.fleet != null) {
            request.addPostParam("Fleet", this.fleet);
        }
        if (this.callbackUrl != null) {
            request.addPostParam("CallbackUrl", this.callbackUrl.toString());
        }
        if (this.callbackMethod != null) {
            request.addPostParam("CallbackMethod", this.callbackMethod.toString());
        }
        if (this.accountSid != null) {
            request.addPostParam("AccountSid", this.accountSid);
        }
    }
}

