/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.Event;
import java.time.ZonedDateTime;

public class EventReader
extends Reader<Event> {
    private String pathWorkspaceSid;
    private ZonedDateTime endDate;
    private String eventType;
    private Integer minutes;
    private String reservationSid;
    private ZonedDateTime startDate;
    private String taskQueueSid;
    private String taskSid;
    private String workerSid;
    private String workflowSid;
    private String taskChannel;
    private String sid;
    private Integer pageSize;

    public EventReader(String pathWorkspaceSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
    }

    public EventReader setEndDate(ZonedDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    public EventReader setEventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public EventReader setMinutes(Integer minutes) {
        this.minutes = minutes;
        return this;
    }

    public EventReader setReservationSid(String reservationSid) {
        this.reservationSid = reservationSid;
        return this;
    }

    public EventReader setStartDate(ZonedDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public EventReader setTaskQueueSid(String taskQueueSid) {
        this.taskQueueSid = taskQueueSid;
        return this;
    }

    public EventReader setTaskSid(String taskSid) {
        this.taskSid = taskSid;
        return this;
    }

    public EventReader setWorkerSid(String workerSid) {
        this.workerSid = workerSid;
        return this;
    }

    public EventReader setWorkflowSid(String workflowSid) {
        this.workflowSid = workflowSid;
        return this;
    }

    public EventReader setTaskChannel(String taskChannel) {
        this.taskChannel = taskChannel;
        return this;
    }

    public EventReader setSid(String sid) {
        this.sid = sid;
        return this;
    }

    public EventReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Event> read(TwilioRestClient client) {
        return new ResourceSet<Event>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Event> firstPage(TwilioRestClient client) {
        String path = "/v1/Workspaces/{WorkspaceSid}/Events";
        path = path.replace("{WorkspaceSid}", this.pathWorkspaceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.TASKROUTER.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<Event> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Event read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("events", response.getContent(), Event.class, client.getObjectMapper());
    }

    @Override
    public Page<Event> previousPage(Page<Event> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.TASKROUTER.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Event> nextPage(Page<Event> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.TASKROUTER.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Event> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate.toInstant().toString());
        }
        if (this.eventType != null) {
            request.addQueryParam("EventType", this.eventType);
        }
        if (this.minutes != null) {
            request.addQueryParam("Minutes", this.minutes.toString());
        }
        if (this.reservationSid != null) {
            request.addQueryParam("ReservationSid", this.reservationSid);
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate.toInstant().toString());
        }
        if (this.taskQueueSid != null) {
            request.addQueryParam("TaskQueueSid", this.taskQueueSid);
        }
        if (this.taskSid != null) {
            request.addQueryParam("TaskSid", this.taskSid);
        }
        if (this.workerSid != null) {
            request.addQueryParam("WorkerSid", this.workerSid);
        }
        if (this.workflowSid != null) {
            request.addQueryParam("WorkflowSid", this.workflowSid);
        }
        if (this.taskChannel != null) {
            request.addQueryParam("TaskChannel", this.taskChannel);
        }
        if (this.sid != null) {
            request.addQueryParam("Sid", this.sid);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

