/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.Task;
import java.time.ZonedDateTime;

public class TaskUpdater
extends Updater<Task> {
    private String pathWorkspaceSid;
    private String pathSid;
    private String ifMatch;
    private String attributes;
    private Task.Status assignmentStatus;
    private String reason;
    private Integer priority;
    private String taskChannel;
    private ZonedDateTime virtualStartTime;

    public TaskUpdater(String pathWorkspaceSid, String pathSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.pathSid = pathSid;
    }

    public TaskUpdater setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
        return this;
    }

    public TaskUpdater setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public TaskUpdater setAssignmentStatus(Task.Status assignmentStatus) {
        this.assignmentStatus = assignmentStatus;
        return this;
    }

    public TaskUpdater setReason(String reason) {
        this.reason = reason;
        return this;
    }

    public TaskUpdater setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public TaskUpdater setTaskChannel(String taskChannel) {
        this.taskChannel = taskChannel;
        return this;
    }

    public TaskUpdater setVirtualStartTime(ZonedDateTime virtualStartTime) {
        this.virtualStartTime = virtualStartTime;
        return this;
    }

    @Override
    public Task update(TwilioRestClient client) {
        String path = "/v1/Workspaces/{WorkspaceSid}/Tasks/{Sid}";
        path = path.replace("{WorkspaceSid}", this.pathWorkspaceSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.TASKROUTER.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Task update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Task.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
        if (this.assignmentStatus != null) {
            request.addPostParam("AssignmentStatus", this.assignmentStatus.toString());
        }
        if (this.reason != null) {
            request.addPostParam("Reason", this.reason);
        }
        if (this.priority != null) {
            request.addPostParam("Priority", this.priority.toString());
        }
        if (this.taskChannel != null) {
            request.addPostParam("TaskChannel", this.taskChannel);
        }
        if (this.virtualStartTime != null) {
            request.addPostParam("VirtualStartTime", this.virtualStartTime.toInstant().toString());
        }
    }

    private void addHeaderParams(Request request) {
        if (this.ifMatch != null) {
            request.addHeaderParam("If-Match", this.ifMatch);
        }
    }
}

