/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.taskqueue;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.taskqueue.TaskQueueRealTimeStatistics;

public class TaskQueueRealTimeStatisticsFetcher
extends Fetcher<TaskQueueRealTimeStatistics> {
    private String pathWorkspaceSid;
    private String pathTaskQueueSid;
    private String taskChannel;

    public TaskQueueRealTimeStatisticsFetcher(String pathWorkspaceSid, String pathTaskQueueSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.pathTaskQueueSid = pathTaskQueueSid;
    }

    public TaskQueueRealTimeStatisticsFetcher setTaskChannel(String taskChannel) {
        this.taskChannel = taskChannel;
        return this;
    }

    @Override
    public TaskQueueRealTimeStatistics fetch(TwilioRestClient client) {
        String path = "/v1/Workspaces/{WorkspaceSid}/TaskQueues/{TaskQueueSid}/RealTimeStatistics";
        path = path.replace("{WorkspaceSid}", this.pathWorkspaceSid.toString());
        path = path.replace("{TaskQueueSid}", this.pathTaskQueueSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.TASKROUTER.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TaskQueueRealTimeStatistics fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return TaskQueueRealTimeStatistics.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.taskChannel != null) {
            request.addQueryParam("TaskChannel", this.taskChannel);
        }
    }
}

