/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trunking.v1.trunk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.trunking.v1.trunk.CredentialListCreator;
import com.twilio.rest.trunking.v1.trunk.CredentialListDeleter;
import com.twilio.rest.trunking.v1.trunk.CredentialListFetcher;
import com.twilio.rest.trunking.v1.trunk.CredentialListReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CredentialList
extends Resource {
    private static final long serialVersionUID = 198091197266991L;
    private final String accountSid;
    private final String sid;
    private final String trunkSid;
    private final String friendlyName;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    public static CredentialListCreator creator(String pathTrunkSid, String credentialListSid) {
        return new CredentialListCreator(pathTrunkSid, credentialListSid);
    }

    public static CredentialListDeleter deleter(String pathTrunkSid, String pathSid) {
        return new CredentialListDeleter(pathTrunkSid, pathSid);
    }

    public static CredentialListFetcher fetcher(String pathTrunkSid, String pathSid) {
        return new CredentialListFetcher(pathTrunkSid, pathSid);
    }

    public static CredentialListReader reader(String pathTrunkSid) {
        return new CredentialListReader(pathTrunkSid);
    }

    public static CredentialList fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, CredentialList.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static CredentialList fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, CredentialList.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private CredentialList(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="trunk_sid") String trunkSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.sid = sid;
        this.trunkSid = trunkSid;
        this.friendlyName = friendlyName;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getTrunkSid() {
        return this.trunkSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CredentialList other = (CredentialList)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.trunkSid, other.trunkSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.sid, this.trunkSid, this.friendlyName, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return "CredentialList(accountSid=" + this.getAccountSid() + ", sid=" + this.getSid() + ", trunkSid=" + this.getTrunkSid() + ", friendlyName=" + this.getFriendlyName() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ")";
    }
}

