/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1.trustproducts;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trusthub.v1.trustproducts.TrustProductsChannelEndpointAssignment;

public class TrustProductsChannelEndpointAssignmentCreator
extends Creator<TrustProductsChannelEndpointAssignment> {
    private String pathTrustProductSid;
    private String channelEndpointType;
    private String channelEndpointSid;

    public TrustProductsChannelEndpointAssignmentCreator(String pathTrustProductSid, String channelEndpointType, String channelEndpointSid) {
        this.pathTrustProductSid = pathTrustProductSid;
        this.channelEndpointType = channelEndpointType;
        this.channelEndpointSid = channelEndpointSid;
    }

    public TrustProductsChannelEndpointAssignmentCreator setChannelEndpointType(String channelEndpointType) {
        this.channelEndpointType = channelEndpointType;
        return this;
    }

    public TrustProductsChannelEndpointAssignmentCreator setChannelEndpointSid(String channelEndpointSid) {
        this.channelEndpointSid = channelEndpointSid;
        return this;
    }

    @Override
    public TrustProductsChannelEndpointAssignment create(TwilioRestClient client) {
        String path = "/v1/TrustProducts/{TrustProductSid}/ChannelEndpointAssignments";
        path = path.replace("{TrustProductSid}", this.pathTrustProductSid.toString());
        path = path.replace("{ChannelEndpointType}", this.channelEndpointType.toString());
        path = path.replace("{ChannelEndpointSid}", this.channelEndpointSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.TRUSTHUB.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TrustProductsChannelEndpointAssignment creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return TrustProductsChannelEndpointAssignment.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.channelEndpointType != null) {
            request.addPostParam("ChannelEndpointType", this.channelEndpointType);
        }
        if (this.channelEndpointSid != null) {
            request.addPostParam("ChannelEndpointSid", this.channelEndpointSid);
        }
    }
}

