/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.AccessToken;

public class AccessTokenCreator
extends Creator<AccessToken> {
    private String pathServiceSid;
    private String identity;
    private AccessToken.FactorTypes factorType;
    private String factorFriendlyName;
    private Integer ttl;

    public AccessTokenCreator(String pathServiceSid, String identity, AccessToken.FactorTypes factorType) {
        this.pathServiceSid = pathServiceSid;
        this.identity = identity;
        this.factorType = factorType;
    }

    public AccessTokenCreator setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public AccessTokenCreator setFactorType(AccessToken.FactorTypes factorType) {
        this.factorType = factorType;
        return this;
    }

    public AccessTokenCreator setFactorFriendlyName(String factorFriendlyName) {
        this.factorFriendlyName = factorFriendlyName;
        return this;
    }

    public AccessTokenCreator setTtl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    @Override
    public AccessToken create(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/AccessTokens";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{Identity}", this.identity.toString());
        path = path.replace("{FactorType}", this.factorType.toString());
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AccessToken creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return AccessToken.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.identity != null) {
            request.addPostParam("Identity", this.identity);
        }
        if (this.factorType != null) {
            request.addPostParam("FactorType", this.factorType.toString());
        }
        if (this.factorFriendlyName != null) {
            request.addPostParam("FactorFriendlyName", this.factorFriendlyName);
        }
        if (this.ttl != null) {
            request.addPostParam("Ttl", this.ttl.toString());
        }
    }
}

