/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.verify.v2.service.WebhookCreator;
import com.twilio.rest.verify.v2.service.WebhookDeleter;
import com.twilio.rest.verify.v2.service.WebhookFetcher;
import com.twilio.rest.verify.v2.service.WebhookReader;
import com.twilio.rest.verify.v2.service.WebhookUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Webhook
extends Resource {
    private static final long serialVersionUID = 178052740611913L;
    private final String sid;
    private final String serviceSid;
    private final String accountSid;
    private final String friendlyName;
    private final List<String> eventTypes;
    private final Status status;
    private final Version version;
    private final URI webhookUrl;
    private final Methods webhookMethod;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    public static WebhookCreator creator(String pathServiceSid, String friendlyName, List<String> eventTypes, String webhookUrl) {
        return new WebhookCreator(pathServiceSid, friendlyName, eventTypes, webhookUrl);
    }

    public static WebhookDeleter deleter(String pathServiceSid, String pathSid) {
        return new WebhookDeleter(pathServiceSid, pathSid);
    }

    public static WebhookFetcher fetcher(String pathServiceSid, String pathSid) {
        return new WebhookFetcher(pathServiceSid, pathSid);
    }

    public static WebhookReader reader(String pathServiceSid) {
        return new WebhookReader(pathServiceSid);
    }

    public static WebhookUpdater updater(String pathServiceSid, String pathSid) {
        return new WebhookUpdater(pathServiceSid, pathSid);
    }

    public static Webhook fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Webhook.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Webhook fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Webhook.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Webhook(@JsonProperty(value="sid") String sid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="event_types") List<String> eventTypes, @JsonProperty(value="status") Status status, @JsonProperty(value="version") Version version, @JsonProperty(value="webhook_url") URI webhookUrl, @JsonProperty(value="webhook_method") Methods webhookMethod, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.serviceSid = serviceSid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.eventTypes = eventTypes;
        this.status = status;
        this.version = version;
        this.webhookUrl = webhookUrl;
        this.webhookMethod = webhookMethod;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final List<String> getEventTypes() {
        return this.eventTypes;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Version getVersion() {
        return this.version;
    }

    public final URI getWebhookUrl() {
        return this.webhookUrl;
    }

    public final Methods getWebhookMethod() {
        return this.webhookMethod;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook other = (Webhook)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.eventTypes, other.eventTypes) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.version, (Object)other.version) && Objects.equals(this.webhookUrl, other.webhookUrl) && Objects.equals((Object)this.webhookMethod, (Object)other.webhookMethod) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.serviceSid, this.accountSid, this.friendlyName, this.eventTypes, this.status, this.version, this.webhookUrl, this.webhookMethod, this.dateCreated, this.dateUpdated, this.url});
    }

    public String toString() {
        return "Webhook(sid=" + this.getSid() + ", serviceSid=" + this.getServiceSid() + ", accountSid=" + this.getAccountSid() + ", friendlyName=" + this.getFriendlyName() + ", eventTypes=" + this.getEventTypes() + ", status=" + (Object)((Object)this.getStatus()) + ", version=" + (Object)((Object)this.getVersion()) + ", webhookUrl=" + this.getWebhookUrl() + ", webhookMethod=" + (Object)((Object)this.getWebhookMethod()) + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ")";
    }

    public static enum Status {
        ENABLED("enabled"),
        DISABLED("disabled");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }

    public static enum Methods {
        GET("GET"),
        POST("POST");

        private final String value;

        private Methods(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Methods forValue(String value) {
            return (Methods)Promoter.enumFromString((String)value, (Enum[])Methods.values());
        }
    }

    public static enum Version {
        V1("v1"),
        V2("v2");

        private final String value;

        private Version(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Version forValue(String value) {
            return (Version)Promoter.enumFromString((String)value, (Enum[])Version.values());
        }
    }
}

