/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service.entity;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.entity.Challenge;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

public class ChallengeCreator
extends Creator<Challenge> {
    private String pathServiceSid;
    private String pathIdentity;
    private String factorSid;
    private ZonedDateTime expirationDate;
    private String detailsMessage;
    private List<Map<String, Object>> detailsFields;
    private Map<String, Object> hiddenDetails;
    private String authPayload;

    public ChallengeCreator(String pathServiceSid, String pathIdentity, String factorSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathIdentity = pathIdentity;
        this.factorSid = factorSid;
    }

    public ChallengeCreator setFactorSid(String factorSid) {
        this.factorSid = factorSid;
        return this;
    }

    public ChallengeCreator setExpirationDate(ZonedDateTime expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    public ChallengeCreator setDetailsMessage(String detailsMessage) {
        this.detailsMessage = detailsMessage;
        return this;
    }

    public ChallengeCreator setDetailsFields(List<Map<String, Object>> detailsFields) {
        this.detailsFields = detailsFields;
        return this;
    }

    public ChallengeCreator setDetailsFields(Map<String, Object> detailsFields) {
        return this.setDetailsFields(Promoter.listOfOne(detailsFields));
    }

    public ChallengeCreator setHiddenDetails(Map<String, Object> hiddenDetails) {
        this.hiddenDetails = hiddenDetails;
        return this;
    }

    public ChallengeCreator setAuthPayload(String authPayload) {
        this.authPayload = authPayload;
        return this;
    }

    @Override
    public Challenge create(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/Entities/{Identity}/Challenges";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{Identity}", this.pathIdentity.toString());
        path = path.replace("{FactorSid}", this.factorSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Challenge creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Challenge.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.factorSid != null) {
            request.addPostParam("FactorSid", this.factorSid);
        }
        if (this.expirationDate != null) {
            request.addPostParam("ExpirationDate", this.expirationDate.toInstant().toString());
        }
        if (this.detailsMessage != null) {
            request.addPostParam("Details.Message", this.detailsMessage);
        }
        if (this.detailsFields != null) {
            for (Map<String, Object> prop : this.detailsFields) {
                request.addPostParam("Details.Fields", Converter.mapToJson(prop));
            }
        }
        if (this.hiddenDetails != null) {
            request.addPostParam("HiddenDetails", Converter.mapToJson(this.hiddenDetails));
        }
        if (this.authPayload != null) {
            request.addPostParam("AuthPayload", this.authPayload);
        }
    }
}

