/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service.ratelimit;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.ratelimit.Bucket;

public class BucketReader
extends Reader<Bucket> {
    private String pathServiceSid;
    private String pathRateLimitSid;
    private Integer pageSize;

    public BucketReader(String pathServiceSid, String pathRateLimitSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathRateLimitSid = pathRateLimitSid;
    }

    public BucketReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Bucket> read(TwilioRestClient client) {
        return new ResourceSet<Bucket>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Bucket> firstPage(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/RateLimits/{RateLimitSid}/Buckets";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{RateLimitSid}", this.pathRateLimitSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.VERIFY.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<Bucket> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Bucket read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("buckets", response.getContent(), Bucket.class, client.getObjectMapper());
    }

    @Override
    public Page<Bucket> previousPage(Page<Bucket> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.VERIFY.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Bucket> nextPage(Page<Bucket> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.VERIFY.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Bucket> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

