/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service.ratelimit;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.ratelimit.Bucket;

public class BucketUpdater
extends Updater<Bucket> {
    private String pathServiceSid;
    private String pathRateLimitSid;
    private String pathSid;
    private Integer max;
    private Integer interval;

    public BucketUpdater(String pathServiceSid, String pathRateLimitSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathRateLimitSid = pathRateLimitSid;
        this.pathSid = pathSid;
    }

    public BucketUpdater setMax(Integer max) {
        this.max = max;
        return this;
    }

    public BucketUpdater setInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    @Override
    public Bucket update(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/RateLimits/{RateLimitSid}/Buckets/{Sid}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{RateLimitSid}", this.pathRateLimitSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Bucket update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Bucket.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.max != null) {
            request.addPostParam("Max", this.max.toString());
        }
        if (this.interval != null) {
            request.addPostParam("Interval", this.interval.toString());
        }
    }
}

