/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1.room;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.video.v1.room.Participant;
import java.time.ZonedDateTime;

public class ParticipantReader
extends Reader<Participant> {
    private String pathRoomSid;
    private Participant.Status status;
    private String identity;
    private ZonedDateTime dateCreatedAfter;
    private ZonedDateTime dateCreatedBefore;
    private Integer pageSize;

    public ParticipantReader(String pathRoomSid) {
        this.pathRoomSid = pathRoomSid;
    }

    public ParticipantReader setStatus(Participant.Status status) {
        this.status = status;
        return this;
    }

    public ParticipantReader setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public ParticipantReader setDateCreatedAfter(ZonedDateTime dateCreatedAfter) {
        this.dateCreatedAfter = dateCreatedAfter;
        return this;
    }

    public ParticipantReader setDateCreatedBefore(ZonedDateTime dateCreatedBefore) {
        this.dateCreatedBefore = dateCreatedBefore;
        return this;
    }

    public ParticipantReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Participant> read(TwilioRestClient client) {
        return new ResourceSet<Participant>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Participant> firstPage(TwilioRestClient client) {
        String path = "/v1/Rooms/{RoomSid}/Participants";
        path = path.replace("{RoomSid}", this.pathRoomSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.VIDEO.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<Participant> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Participant read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("participants", response.getContent(), Participant.class, client.getObjectMapper());
    }

    @Override
    public Page<Participant> previousPage(Page<Participant> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.VIDEO.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Participant> nextPage(Page<Participant> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.VIDEO.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Participant> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.identity != null) {
            request.addQueryParam("Identity", this.identity);
        }
        if (this.dateCreatedAfter != null) {
            request.addQueryParam("DateCreatedAfter", this.dateCreatedAfter.toInstant().toString());
        }
        if (this.dateCreatedBefore != null) {
            request.addQueryParam("DateCreatedBefore", this.dateCreatedBefore.toInstant().toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

