/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1.dialingpermissions.country;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.voice.v1.dialingpermissions.country.HighriskSpecialPrefix;

public class HighriskSpecialPrefixReader
extends Reader<HighriskSpecialPrefix> {
    private String pathIsoCode;
    private Integer pageSize;

    public HighriskSpecialPrefixReader(String pathIsoCode) {
        this.pathIsoCode = pathIsoCode;
    }

    public HighriskSpecialPrefixReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<HighriskSpecialPrefix> read(TwilioRestClient client) {
        return new ResourceSet<HighriskSpecialPrefix>(this, client, this.firstPage(client));
    }

    @Override
    public Page<HighriskSpecialPrefix> firstPage(TwilioRestClient client) {
        String path = "/v1/DialingPermissions/Countries/{IsoCode}/HighRiskSpecialPrefixes";
        path = path.replace("{IsoCode}", this.pathIsoCode.toString());
        Request request = new Request(HttpMethod.GET, Domains.VOICE.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<HighriskSpecialPrefix> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("HighriskSpecialPrefix read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("content", response.getContent(), HighriskSpecialPrefix.class, client.getObjectMapper());
    }

    @Override
    public Page<HighriskSpecialPrefix> previousPage(Page<HighriskSpecialPrefix> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.VOICE.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<HighriskSpecialPrefix> nextPage(Page<HighriskSpecialPrefix> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.VOICE.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<HighriskSpecialPrefix> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

