/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.wireless.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.wireless.v1.RatePlan;
import java.util.List;

public class RatePlanCreator
extends Creator<RatePlan> {
    private String uniqueName;
    private String friendlyName;
    private Boolean dataEnabled;
    private Integer dataLimit;
    private String dataMetering;
    private Boolean messagingEnabled;
    private Boolean voiceEnabled;
    private Boolean nationalRoamingEnabled;
    private List<String> internationalRoaming;
    private Integer nationalRoamingDataLimit;
    private Integer internationalRoamingDataLimit;

    public RatePlanCreator setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public RatePlanCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public RatePlanCreator setDataEnabled(Boolean dataEnabled) {
        this.dataEnabled = dataEnabled;
        return this;
    }

    public RatePlanCreator setDataLimit(Integer dataLimit) {
        this.dataLimit = dataLimit;
        return this;
    }

    public RatePlanCreator setDataMetering(String dataMetering) {
        this.dataMetering = dataMetering;
        return this;
    }

    public RatePlanCreator setMessagingEnabled(Boolean messagingEnabled) {
        this.messagingEnabled = messagingEnabled;
        return this;
    }

    public RatePlanCreator setVoiceEnabled(Boolean voiceEnabled) {
        this.voiceEnabled = voiceEnabled;
        return this;
    }

    public RatePlanCreator setNationalRoamingEnabled(Boolean nationalRoamingEnabled) {
        this.nationalRoamingEnabled = nationalRoamingEnabled;
        return this;
    }

    public RatePlanCreator setInternationalRoaming(List<String> internationalRoaming) {
        this.internationalRoaming = internationalRoaming;
        return this;
    }

    public RatePlanCreator setInternationalRoaming(String internationalRoaming) {
        return this.setInternationalRoaming(Promoter.listOfOne(internationalRoaming));
    }

    public RatePlanCreator setNationalRoamingDataLimit(Integer nationalRoamingDataLimit) {
        this.nationalRoamingDataLimit = nationalRoamingDataLimit;
        return this;
    }

    public RatePlanCreator setInternationalRoamingDataLimit(Integer internationalRoamingDataLimit) {
        this.internationalRoamingDataLimit = internationalRoamingDataLimit;
        return this;
    }

    @Override
    public RatePlan create(TwilioRestClient client) {
        String path = "/v1/RatePlans";
        Request request = new Request(HttpMethod.POST, Domains.WIRELESS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("RatePlan creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return RatePlan.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.dataEnabled != null) {
            request.addPostParam("DataEnabled", this.dataEnabled.toString());
        }
        if (this.dataLimit != null) {
            request.addPostParam("DataLimit", this.dataLimit.toString());
        }
        if (this.dataMetering != null) {
            request.addPostParam("DataMetering", this.dataMetering);
        }
        if (this.messagingEnabled != null) {
            request.addPostParam("MessagingEnabled", this.messagingEnabled.toString());
        }
        if (this.voiceEnabled != null) {
            request.addPostParam("VoiceEnabled", this.voiceEnabled.toString());
        }
        if (this.nationalRoamingEnabled != null) {
            request.addPostParam("NationalRoamingEnabled", this.nationalRoamingEnabled.toString());
        }
        if (this.internationalRoaming != null) {
            for (String prop : this.internationalRoaming) {
                request.addPostParam("InternationalRoaming", prop);
            }
        }
        if (this.nationalRoamingDataLimit != null) {
            request.addPostParam("NationalRoamingDataLimit", this.nationalRoamingDataLimit.toString());
        }
        if (this.internationalRoamingDataLimit != null) {
            request.addPostParam("InternationalRoamingDataLimit", this.internationalRoamingDataLimit.toString());
        }
    }
}

