/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.wireless.v1.sim;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.wireless.v1.sim.DataSessionReader;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DataSession
extends Resource {
    private static final long serialVersionUID = 124844690346008L;
    private final String sid;
    private final String simSid;
    private final String accountSid;
    private final String radioLink;
    private final String operatorMcc;
    private final String operatorMnc;
    private final String operatorCountry;
    private final String operatorName;
    private final String cellId;
    private final Map<String, Object> cellLocationEstimate;
    private final Integer packetsUploaded;
    private final Integer packetsDownloaded;
    private final ZonedDateTime lastUpdated;
    private final ZonedDateTime start;
    private final ZonedDateTime end;
    private final String imei;

    public static DataSessionReader reader(String pathSimSid) {
        return new DataSessionReader(pathSimSid);
    }

    public static DataSession fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, DataSession.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static DataSession fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, DataSession.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private DataSession(@JsonProperty(value="sid") String sid, @JsonProperty(value="sim_sid") String simSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="radio_link") String radioLink, @JsonProperty(value="operator_mcc") String operatorMcc, @JsonProperty(value="operator_mnc") String operatorMnc, @JsonProperty(value="operator_country") String operatorCountry, @JsonProperty(value="operator_name") String operatorName, @JsonProperty(value="cell_id") String cellId, @JsonProperty(value="cell_location_estimate") Map<String, Object> cellLocationEstimate, @JsonProperty(value="packets_uploaded") Integer packetsUploaded, @JsonProperty(value="packets_downloaded") Integer packetsDownloaded, @JsonProperty(value="last_updated") String lastUpdated, @JsonProperty(value="start") String start, @JsonProperty(value="end") String end, @JsonProperty(value="imei") String imei) {
        this.sid = sid;
        this.simSid = simSid;
        this.accountSid = accountSid;
        this.radioLink = radioLink;
        this.operatorMcc = operatorMcc;
        this.operatorMnc = operatorMnc;
        this.operatorCountry = operatorCountry;
        this.operatorName = operatorName;
        this.cellId = cellId;
        this.cellLocationEstimate = cellLocationEstimate;
        this.packetsUploaded = packetsUploaded;
        this.packetsDownloaded = packetsDownloaded;
        this.lastUpdated = DateConverter.iso8601DateTimeFromString(lastUpdated);
        this.start = DateConverter.iso8601DateTimeFromString(start);
        this.end = DateConverter.iso8601DateTimeFromString(end);
        this.imei = imei;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getSimSid() {
        return this.simSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getRadioLink() {
        return this.radioLink;
    }

    public final String getOperatorMcc() {
        return this.operatorMcc;
    }

    public final String getOperatorMnc() {
        return this.operatorMnc;
    }

    public final String getOperatorCountry() {
        return this.operatorCountry;
    }

    public final String getOperatorName() {
        return this.operatorName;
    }

    public final String getCellId() {
        return this.cellId;
    }

    public final Map<String, Object> getCellLocationEstimate() {
        return this.cellLocationEstimate;
    }

    public final Integer getPacketsUploaded() {
        return this.packetsUploaded;
    }

    public final Integer getPacketsDownloaded() {
        return this.packetsDownloaded;
    }

    public final ZonedDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public final ZonedDateTime getStart() {
        return this.start;
    }

    public final ZonedDateTime getEnd() {
        return this.end;
    }

    public final String getImei() {
        return this.imei;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSession other = (DataSession)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.simSid, other.simSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.radioLink, other.radioLink) && Objects.equals(this.operatorMcc, other.operatorMcc) && Objects.equals(this.operatorMnc, other.operatorMnc) && Objects.equals(this.operatorCountry, other.operatorCountry) && Objects.equals(this.operatorName, other.operatorName) && Objects.equals(this.cellId, other.cellId) && Objects.equals(this.cellLocationEstimate, other.cellLocationEstimate) && Objects.equals(this.packetsUploaded, other.packetsUploaded) && Objects.equals(this.packetsDownloaded, other.packetsDownloaded) && Objects.equals(this.lastUpdated, other.lastUpdated) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.imei, other.imei);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.simSid, this.accountSid, this.radioLink, this.operatorMcc, this.operatorMnc, this.operatorCountry, this.operatorName, this.cellId, this.cellLocationEstimate, this.packetsUploaded, this.packetsDownloaded, this.lastUpdated, this.start, this.end, this.imei);
    }

    public String toString() {
        return "DataSession(sid=" + this.getSid() + ", simSid=" + this.getSimSid() + ", accountSid=" + this.getAccountSid() + ", radioLink=" + this.getRadioLink() + ", operatorMcc=" + this.getOperatorMcc() + ", operatorMnc=" + this.getOperatorMnc() + ", operatorCountry=" + this.getOperatorCountry() + ", operatorName=" + this.getOperatorName() + ", cellId=" + this.getCellId() + ", cellLocationEstimate=" + this.getCellLocationEstimate() + ", packetsUploaded=" + this.getPacketsUploaded() + ", packetsDownloaded=" + this.getPacketsDownloaded() + ", lastUpdated=" + this.getLastUpdated() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ", imei=" + this.getImei() + ")";
    }
}

