/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class Record
extends TwiML {
    private final URI action;
    private final HttpMethod method;
    private final Integer timeout;
    private final String finishOnKey;
    private final Integer maxLength;
    private final Boolean playBeep;
    private final Trim trim;
    private final URI recordingStatusCallback;
    private final HttpMethod recordingStatusCallbackMethod;
    private final List<RecordingEvent> recordingStatusCallbackEvent;
    private final Boolean transcribe;
    private final URI transcribeCallback;

    private Record() {
        this(new Builder());
    }

    private Record(Builder b) {
        super("Record", b);
        this.action = b.action;
        this.method = b.method;
        this.timeout = b.timeout;
        this.finishOnKey = b.finishOnKey;
        this.maxLength = b.maxLength;
        this.playBeep = b.playBeep;
        this.trim = b.trim;
        this.recordingStatusCallback = b.recordingStatusCallback;
        this.recordingStatusCallbackMethod = b.recordingStatusCallbackMethod;
        this.recordingStatusCallbackEvent = b.recordingStatusCallbackEvent;
        this.transcribe = b.transcribe;
        this.transcribeCallback = b.transcribeCallback;
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getAction() != null) {
            attrs.put("action", this.getAction().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getTimeout() != null) {
            attrs.put("timeout", this.getTimeout().toString());
        }
        if (this.getFinishOnKey() != null) {
            attrs.put("finishOnKey", this.getFinishOnKey());
        }
        if (this.getMaxLength() != null) {
            attrs.put("maxLength", this.getMaxLength().toString());
        }
        if (this.isPlayBeep() != null) {
            attrs.put("playBeep", this.isPlayBeep().toString());
        }
        if (this.getTrim() != null) {
            attrs.put("trim", this.getTrim().toString());
        }
        if (this.getRecordingStatusCallback() != null) {
            attrs.put("recordingStatusCallback", this.getRecordingStatusCallback().toString());
        }
        if (this.getRecordingStatusCallbackMethod() != null) {
            attrs.put("recordingStatusCallbackMethod", this.getRecordingStatusCallbackMethod().toString());
        }
        if (this.getRecordingStatusCallbackEvents() != null) {
            attrs.put("recordingStatusCallbackEvent", this.getRecordingStatusCallbackEventsAsString());
        }
        if (this.isTranscribe() != null) {
            attrs.put("transcribe", this.isTranscribe().toString());
        }
        if (this.getTranscribeCallback() != null) {
            attrs.put("transcribeCallback", this.getTranscribeCallback().toString());
        }
        return attrs;
    }

    public URI getAction() {
        return this.action;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public String getFinishOnKey() {
        return this.finishOnKey;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Boolean isPlayBeep() {
        return this.playBeep;
    }

    public Trim getTrim() {
        return this.trim;
    }

    public URI getRecordingStatusCallback() {
        return this.recordingStatusCallback;
    }

    public HttpMethod getRecordingStatusCallbackMethod() {
        return this.recordingStatusCallbackMethod;
    }

    public List<RecordingEvent> getRecordingStatusCallbackEvents() {
        return this.recordingStatusCallbackEvent;
    }

    protected String getRecordingStatusCallbackEventsAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<RecordingEvent> iter = this.getRecordingStatusCallbackEvents().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public Boolean isTranscribe() {
        return this.transcribe;
    }

    public URI getTranscribeCallback() {
        return this.transcribeCallback;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private URI action;
        private HttpMethod method;
        private Integer timeout;
        private String finishOnKey;
        private Integer maxLength;
        private Boolean playBeep;
        private Trim trim;
        private URI recordingStatusCallback;
        private HttpMethod recordingStatusCallbackMethod;
        private List<RecordingEvent> recordingStatusCallbackEvent;
        private Boolean transcribe;
        private URI transcribeCallback;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a Record.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        @JacksonXmlProperty(isAttribute=true, localName="action")
        public Builder action(URI action) {
            this.action = action;
            return this;
        }

        public Builder action(String action) {
            this.action = Promoter.uriFromString(action);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="method")
        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="timeout")
        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="finishOnKey")
        public Builder finishOnKey(String finishOnKey) {
            this.finishOnKey = finishOnKey;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="maxLength")
        public Builder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="playBeep")
        public Builder playBeep(Boolean playBeep) {
            this.playBeep = playBeep;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="trim")
        public Builder trim(Trim trim) {
            this.trim = trim;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="recordingStatusCallback")
        public Builder recordingStatusCallback(URI recordingStatusCallback) {
            this.recordingStatusCallback = recordingStatusCallback;
            return this;
        }

        public Builder recordingStatusCallback(String recordingStatusCallback) {
            this.recordingStatusCallback = Promoter.uriFromString(recordingStatusCallback);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="recordingStatusCallbackMethod")
        public Builder recordingStatusCallbackMethod(HttpMethod recordingStatusCallbackMethod) {
            this.recordingStatusCallbackMethod = recordingStatusCallbackMethod;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="recordingStatusCallbackEvent")
        public Builder recordingStatusCallbackEvents(List<RecordingEvent> recordingStatusCallbackEvent) {
            this.recordingStatusCallbackEvent = recordingStatusCallbackEvent;
            return this;
        }

        public Builder recordingStatusCallbackEvents(RecordingEvent recordingStatusCallbackEvent) {
            this.recordingStatusCallbackEvent = Promoter.listOfOne(recordingStatusCallbackEvent);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="transcribe")
        public Builder transcribe(Boolean transcribe) {
            this.transcribe = transcribe;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="transcribeCallback")
        public Builder transcribeCallback(URI transcribeCallback) {
            this.transcribeCallback = transcribeCallback;
            return this;
        }

        public Builder transcribeCallback(String transcribeCallback) {
            this.transcribeCallback = Promoter.uriFromString(transcribeCallback);
            return this;
        }

        public Record build() {
            return new Record(this);
        }
    }

    public static enum RecordingEvent {
        IN_PROGRESS("in-progress"),
        COMPLETED("completed"),
        ABSENT("absent");

        private final String value;

        private RecordingEvent(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Trim {
        TRIM_SILENCE("trim-silence"),
        DO_NOT_TRIM("do-not-trim");

        private final String value;

        private Trim(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

