/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class SsmlPhoneme
extends TwiML {
    private final Alphabet alphabet;
    private final String ph;
    private final String words;

    private SsmlPhoneme() {
        this(new Builder(null));
    }

    private SsmlPhoneme(Builder b) {
        super("phoneme", b);
        this.alphabet = b.alphabet;
        this.ph = b.ph;
        this.words = b.words;
    }

    @Override
    protected String getElementBody() {
        return this.getWords() == null ? null : this.getWords();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getAlphabet() != null) {
            attrs.put("alphabet", this.getAlphabet().toString());
        }
        if (this.getPh() != null) {
            attrs.put("ph", this.getPh());
        }
        return attrs;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public String getPh() {
        return this.ph;
    }

    public String getWords() {
        return this.words;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private Alphabet alphabet;
        private String ph;
        private String words;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a SsmlPhoneme.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        public Builder(String words) {
            this.words = words;
        }

        private Builder() {
        }

        @JacksonXmlProperty(isAttribute=true, localName="alphabet")
        public Builder alphabet(Alphabet alphabet) {
            this.alphabet = alphabet;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="ph")
        public Builder ph(String ph) {
            this.ph = ph;
            return this;
        }

        public SsmlPhoneme build() {
            return new SsmlPhoneme(this);
        }
    }

    public static enum Alphabet {
        IPA("ipa"),
        X_SAMPA("x-sampa"),
        X_AMAZON_JYUTPING("x-amazon-jyutping"),
        X_AMAZON_PINYIN("x-amazon-pinyin"),
        X_AMAZON_PRON_KANA("x-amazon-pron-kana"),
        X_AMAZON_YOMIGANA("x-amazon-yomigana");

        private final String value;

        private Alphabet(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

