/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter;

import org.apache.camel.component.twitter.data.EndpointType;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.util.ObjectHelper;
import twitter4j.Twitter;

@UriParams
public class TwitterConfiguration {
    @UriParam(label="consumer", defaultValue="polling", enums="polling,direct")
    private EndpointType type = EndpointType.POLLING;
    @UriParam(label="security", secret=true)
    private String accessToken;
    @UriParam(label="security", secret=true)
    private String accessTokenSecret;
    @UriParam(label="security", secret=true)
    private String consumerKey;
    @UriParam(label="security", secret=true)
    private String consumerSecret;
    @UriParam(label="consumer,filter")
    private String userIds;
    @UriParam(label="consumer,filter", defaultValue="true")
    private boolean filterOld = true;
    @UriParam(label="consumer,filter", defaultValue="1")
    private long sinceId = 1L;
    @UriParam(label="consumer,filter")
    private String lang;
    @UriParam(label="consumer,filter", defaultValue="5")
    private Integer count = 5;
    @UriParam(label="consumer,filter", defaultValue="1")
    private Integer numberOfPages = 1;
    @UriParam(label="consumer,sort", defaultValue="true")
    private boolean sortById = true;
    @UriParam(label="proxy")
    private String httpProxyHost;
    @UriParam(label="proxy")
    private String httpProxyUser;
    @UriParam(label="proxy")
    private String httpProxyPassword;
    @UriParam(label="proxy")
    private Integer httpProxyPort;
    @UriParam(label="consumer,advanced")
    private String locations;
    @UriParam(label="consumer,advanced")
    private Double latitude;
    @UriParam(label="consumer,advanced")
    private Double longitude;
    @UriParam(label="consumer,advanced")
    private Double radius;
    @UriParam(label="consumer,advanced", defaultValue="km", enums="km,mi")
    private String distanceMetric;
    @UriParam(label="consumer,advanced", defaultValue="true")
    private boolean extendedMode = true;
    private Twitter twitter;

    public void checkComplete() {
        if (this.twitter == null && (ObjectHelper.isEmpty(this.consumerKey) || ObjectHelper.isEmpty(this.consumerSecret) || ObjectHelper.isEmpty(this.accessToken) || ObjectHelper.isEmpty(this.accessTokenSecret))) {
            throw new IllegalArgumentException("twitter or all of consumerKey, consumerSecret, accessToken, and accessTokenSecret must be set!");
        }
    }

    protected Twitter buildTwitter() {
        this.checkComplete();
        Twitter.TwitterBuilder builder = (Twitter.TwitterBuilder)((Twitter.TwitterBuilder)((Twitter.TwitterBuilder)((Twitter.TwitterBuilder)((Twitter.TwitterBuilder)((Twitter.TwitterBuilder)Twitter.newBuilder().oAuthConsumer(this.consumerKey, this.consumerSecret)).oAuthAccessToken(this.accessToken, this.accessTokenSecret)).tweetModeExtended(this.isExtendedMode())).httpProxyHost(this.getHttpProxyHost())).httpProxyUser(this.getHttpProxyUser())).httpProxyPassword(this.getHttpProxyPassword());
        if (this.getHttpProxyPort() != null) {
            builder.httpProxyPort(this.getHttpProxyPort());
        }
        return builder.build();
    }

    public Twitter getTwitter() {
        if (this.twitter == null) {
            this.twitter = this.buildTwitter();
        }
        return this.twitter;
    }

    public void setTwitter(Twitter twitter) {
        this.twitter = twitter;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessTokenSecret() {
        return this.accessTokenSecret;
    }

    public void setAccessTokenSecret(String accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
    }

    public EndpointType getType() {
        return this.type;
    }

    public void setType(EndpointType type) {
        this.type = type;
    }

    public String getLocations() {
        return this.locations;
    }

    public void setLocations(String locations) {
        this.locations = locations;
    }

    public String getUserIds() {
        return this.userIds;
    }

    public void setUserIds(String userIds) {
        this.userIds = userIds;
    }

    public boolean isFilterOld() {
        return this.filterOld;
    }

    public void setFilterOld(boolean filterOld) {
        this.filterOld = filterOld;
    }

    public long getSinceId() {
        return this.sinceId;
    }

    public void setSinceId(long sinceId) {
        this.sinceId = sinceId;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Integer getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setNumberOfPages(Integer numberOfPages) {
        this.numberOfPages = numberOfPages;
    }

    public boolean isSortById() {
        return this.sortById;
    }

    public void setSortById(boolean sortById) {
        this.sortById = sortById;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyUser(String httpProxyUser) {
        this.httpProxyUser = httpProxyUser;
    }

    public String getHttpProxyUser() {
        return this.httpProxyUser;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setHttpProxyPort(Integer httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public Integer getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getRadius() {
        return this.radius;
    }

    public void setRadius(Double radius) {
        this.radius = radius;
    }

    public String getDistanceMetric() {
        return this.distanceMetric;
    }

    public void setDistanceMetric(String distanceMetric) {
        this.distanceMetric = distanceMetric;
    }

    public void setExtendedMode(Boolean extendedMode) {
        this.extendedMode = extendedMode;
    }

    public boolean isExtendedMode() {
        return this.extendedMode;
    }
}

