/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.directmessage;

import java.util.Iterator;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.consumer.AbstractTwitterConsumerHandler;
import org.apache.camel.component.twitter.consumer.TwitterEventType;
import twitter4j.TwitterException;
import twitter4j.v1.DirectMessage;
import twitter4j.v1.DirectMessageList;

public class DirectMessageConsumerHandler
extends AbstractTwitterConsumerHandler {
    public DirectMessageConsumerHandler(TwitterEndpoint te) {
        super(te);
    }

    @Override
    public List<Exchange> pollConsume() throws TwitterException {
        DirectMessageList directMessages = this.directMessages(null, null);
        if (!directMessages.isEmpty()) {
            this.setLastId(((DirectMessage)directMessages.get(0)).getId());
        }
        return TwitterEventType.DIRECT_MESSAGE.createExchangeList(this.endpoint, directMessages);
    }

    private DirectMessageList directMessages(String previousCursor, String cursor) throws TwitterException {
        DirectMessageList directMessages = cursor != null ? this.getTwitter().v1().directMessages().getDirectMessages(this.endpoint.getProperties().getCount(), cursor) : this.getTwitter().v1().directMessages().getDirectMessages(this.endpoint.getProperties().getCount());
        String nextCursor = directMessages.getNextCursor();
        if (nextCursor != null && nextCursor.equals(previousCursor) || directMessages.isEmpty()) {
            directMessages.clear();
            return directMessages;
        }
        if (nextCursor != null) {
            DirectMessageList directMessages2 = this.directMessages(cursor, nextCursor);
            directMessages.addAll(directMessages2);
        }
        if (this.endpoint.getProperties().isFilterOld()) {
            Iterator iterator = directMessages.iterator();
            while (iterator.hasNext()) {
                DirectMessage dm = (DirectMessage)iterator.next();
                long id = dm.getId();
                if (this.getLastId() <= 1L || id > this.getLastId()) continue;
                iterator.remove();
            }
        }
        return directMessages;
    }

    @Override
    public List<Exchange> directConsume() throws TwitterException {
        DirectMessageList directMessages = this.directMessages(null, null);
        return TwitterEventType.DIRECT_MESSAGE.createExchangeList(this.endpoint, directMessages);
    }
}

