/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.search;

import java.util.List;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.Twitter;
import twitter4j.v1.Query;
import twitter4j.v1.QueryResult;
import twitter4j.v1.Status;

public class SearchProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SearchProducer.class);
    private volatile long lastId;
    private TwitterEndpoint endpoint;
    private String keywords;

    public SearchProducer(TwitterEndpoint endpoint, String keywords) {
        super(endpoint);
        this.endpoint = endpoint;
        this.keywords = keywords;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Integer numberOfPages;
        Integer count;
        String lang;
        Long maxId;
        Long sinceId;
        long myLastId = this.lastId;
        String queryKeywords = exchange.getIn().getHeader("CamelTwitterKeywords", String.class);
        if (queryKeywords == null) {
            queryKeywords = this.keywords;
        }
        if (queryKeywords == null) {
            throw new CamelExchangeException("No keywords to use for query", exchange);
        }
        Query query = Query.of(queryKeywords);
        if (this.endpoint.getProperties().isFilterOld() && myLastId != 0L) {
            query.sinceId(myLastId);
        }
        if ((sinceId = exchange.getIn().getHeader("CamelTwitterSinceId", Long.class)) == null) {
            sinceId = this.endpoint.getProperties().getSinceId();
        }
        if (ObjectHelper.isNotEmpty(sinceId)) {
            query.sinceId(sinceId);
        }
        if (ObjectHelper.isNotEmpty(maxId = exchange.getIn().getHeader("CamelTwitterMaxId", Long.class))) {
            query.maxId(maxId);
        }
        if ((lang = exchange.getIn().getHeader("CamelTwitterSearchLanguage", String.class)) == null) {
            lang = this.endpoint.getProperties().getLang();
        }
        if (ObjectHelper.isNotEmpty(lang)) {
            query.lang(lang);
        }
        if ((count = exchange.getIn().getHeader("CamelTwitterCount", Integer.class)) == null) {
            count = this.endpoint.getProperties().getCount();
        }
        if (ObjectHelper.isNotEmpty(count)) {
            query.count(count);
        }
        if ((numberOfPages = exchange.getIn().getHeader("CamelTwitterNumberOfPages", Integer.class)) == null) {
            numberOfPages = this.endpoint.getProperties().getNumberOfPages();
        }
        Twitter twitter = this.endpoint.getProperties().getTwitter();
        LOG.debug("Searching twitter with keywords: {}", (Object)queryKeywords);
        QueryResult results = twitter.v1().search().search(query);
        List<Status> list = results.getTweets();
        for (int i = 1; i < numberOfPages && results.hasNext(); ++i) {
            LOG.debug("Fetching page");
            results = twitter.v1().search().search(results.nextQuery());
            list.addAll(results.getTweets());
        }
        if (this.endpoint.getProperties().isFilterOld()) {
            for (Status t : list) {
                long newId = t.getId();
                if (newId <= myLastId) continue;
                myLastId = newId;
            }
        }
        exchange.getIn().setBody(list);
        if (myLastId > this.lastId) {
            this.lastId = myLastId;
        }
    }
}

