/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.timeline;

import org.apache.camel.Exchange;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.v1.Status;
import twitter4j.v1.StatusUpdate;

public class UserProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(UserProducer.class);
    private TwitterEndpoint endpoint;

    public UserProducer(TwitterEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Status response;
        Object in = exchange.getIn().getBody();
        if (in instanceof StatusUpdate) {
            response = this.updateStatus((StatusUpdate)in);
        } else {
            String s = exchange.getIn().getMandatoryBody(String.class);
            response = this.updateStatus(s);
        }
        ExchangeHelper.setOutBodyPatternAware(exchange, response);
    }

    private Status updateStatus(StatusUpdate status) throws Exception {
        Status response = this.endpoint.getProperties().getTwitter().v1().tweets().updateStatus(status);
        LOG.debug("Updated status: {}", (Object)status);
        LOG.debug("Status id: {}", (Object)response.getId());
        return response;
    }

    private Status updateStatus(String status) throws Exception {
        Status response = this.endpoint.getProperties().getTwitter().v1().tweets().updateStatus(status);
        LOG.debug("Updated status: {}", (Object)status);
        LOG.debug("Status id: {}", (Object)response.getId());
        return response;
    }
}

