/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.predicate.Predicate;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import jakarta.activation.FileDataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.attachment.DefaultAttachment;
import org.apache.camel.component.undertow.ExchangeHeaders;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.component.undertow.UndertowHeaderFilterStrategy;
import org.apache.camel.component.undertow.UndertowHelper;
import org.apache.camel.component.undertow.UndertowHttpBinding;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExceptionHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.http.HttpUtil;
import org.apache.camel.util.BufferCaster;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.channels.BlockingReadableByteChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.streams.ChannelInputStream;

public class DefaultUndertowHttpBinding
implements UndertowHttpBinding {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUndertowHttpBinding.class);
    private HeaderFilterStrategy headerFilterStrategy;
    private Boolean transferException;
    private Boolean muteException;
    private boolean useStreaming;

    public DefaultUndertowHttpBinding() {
        this(false);
    }

    public DefaultUndertowHttpBinding(boolean useStreaming) {
        this.headerFilterStrategy = new UndertowHeaderFilterStrategy();
        this.transferException = Boolean.FALSE;
        this.muteException = Boolean.FALSE;
        this.useStreaming = useStreaming;
    }

    public DefaultUndertowHttpBinding(HeaderFilterStrategy headerFilterStrategy, Boolean transferException, Boolean muteException) {
        this.headerFilterStrategy = headerFilterStrategy;
        this.transferException = transferException;
        this.muteException = muteException;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public Boolean isTransferException() {
        return this.transferException;
    }

    @Override
    public void setTransferException(Boolean transferException) {
        this.transferException = transferException;
    }

    public Boolean isMuteException() {
        return this.muteException;
    }

    @Override
    public void setMuteException(Boolean muteException) {
        this.muteException = muteException;
    }

    @Override
    public Message toCamelMessage(HttpServerExchange httpExchange, Exchange exchange) throws Exception {
        DefaultMessage result = new DefaultMessage(exchange);
        this.populateCamelHeaders(httpExchange, result.getHeaders(), exchange);
        FormData formData = httpExchange.getAttachment(FormDataParser.FORM_DATA);
        if (formData != null) {
            HashMap body = new HashMap();
            formData.forEach(key -> formData.get((String)key).forEach(value -> {
                if (value.isFile()) {
                    DefaultAttachment attachment = new DefaultAttachment(new FilePartDataSource((FormData.FormValue)value));
                    AttachmentMessage am = result.getExchange().getMessage(AttachmentMessage.class);
                    am.addAttachmentObject((String)key, attachment);
                    body.put(key, attachment.getDataHandler());
                } else if (this.headerFilterStrategy != null && !this.headerFilterStrategy.applyFilterToExternalHeaders((String)key, value.getValue(), exchange)) {
                    UndertowHelper.appendHeader(result.getHeaders(), key, value.getValue());
                    UndertowHelper.appendHeader(body, key, value.getValue());
                }
            }));
            result.setBody(body);
        } else if (Methods.POST.equals(httpExchange.getRequestMethod()) || Methods.PUT.equals(httpExchange.getRequestMethod()) || Methods.PATCH.equals(httpExchange.getRequestMethod())) {
            StreamSourceChannel source = httpExchange.getRequestChannel();
            if (this.useStreaming) {
                result.setBody(new ChannelInputStream(source));
            } else {
                result.setBody(this.readFromChannel(source));
            }
        } else {
            result.setBody(null);
        }
        return result;
    }

    @Override
    public Message toCamelMessage(final ClientExchange clientExchange, Exchange exchange) throws Exception {
        DefaultMessage result = new DefaultMessage(exchange.getContext());
        this.populateCamelHeaders(clientExchange.getResponse(), result.getHeaders(), exchange);
        StreamSourceChannel source = clientExchange.getResponseChannel();
        if (this.useStreaming) {
            result.setBody(new ChannelInputStream(source){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        clientExchange.getConnection().close();
                    }
                }
            });
        } else {
            result.setBody(this.readFromChannel(source));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void populateCamelHeaders(HttpServerExchange httpExchange, Map<String, Object> headersMap, Exchange exchange) throws Exception {
        Map<String, Object> map;
        LOG.trace("populateCamelHeaders: {}", exchange.getMessage().getHeaders());
        String path = DefaultUndertowHttpBinding.stripPath(httpExchange, exchange);
        headersMap.put("CamelHttpPath", path);
        if (LOG.isTraceEnabled()) {
            LOG.trace("HTTP-Method {}", (Object)httpExchange.getRequestMethod());
            LOG.trace("HTTP-Uri {}", (Object)httpExchange.getRequestURI());
        }
        for (HttpString httpString : httpExchange.getRequestHeaders().getHeaderNames()) {
            String string;
            void var6_6;
            if (httpString.toString().toLowerCase(Locale.US).equals("content-type")) {
                HttpString httpString2 = ExchangeHeaders.CONTENT_TYPE;
            }
            if (var6_6.toString().toLowerCase(Locale.US).equals("authorization") && (string = httpExchange.getRequestHeaders().get((HttpString)var6_6).toString()) != null && string.trim().startsWith("Basic") && this.headerFilterStrategy != null && !this.headerFilterStrategy.applyFilterToExternalHeaders("CamelAuthentication", "Basic", exchange)) {
                UndertowHelper.appendHeader(headersMap, "CamelAuthentication", "Basic");
            }
            for (String value2 : httpExchange.getRequestHeaders().get((HttpString)var6_6)) {
                LOG.trace("HTTP-header: {}", (Object)value2);
                if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(var6_6.toString(), value2, exchange)) continue;
                UndertowHelper.appendHeader(headersMap, var6_6.toString(), value2);
            }
        }
        Map<String, Deque<String>> pathParameters = httpExchange.getQueryParameters();
        if (!pathParameters.isEmpty()) {
            for (Map.Entry<String, Deque<String>> entry : pathParameters.entrySet()) {
                String name = entry.getKey();
                Deque<String> values = entry.getValue();
                Iterator<?> it = ObjectHelper.createIterator(values);
                while (it.hasNext()) {
                    Object value = it.next();
                    LOG.trace("URI-Parameter: {}", value);
                    if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, value, exchange)) continue;
                    UndertowHelper.appendHeader(headersMap, name, value);
                }
            }
        }
        if ((map = httpExchange.getAttachment(Predicate.PREDICATE_CONTEXT)) != null) {
            map.remove("remaining");
            for (Map.Entry<String, Object> paramEntry : map.entrySet()) {
                String paramName = paramEntry.getKey();
                LOG.trace("REST Template Variable {}: {})", (Object)paramName, paramEntry.getValue());
                headersMap.put(paramName, paramEntry.getValue());
            }
        }
        headersMap.put("CamelHttpMethod", httpExchange.getRequestMethod().toString());
        headersMap.put("CamelHttpUrl", httpExchange.getRequestURL());
        headersMap.put("CamelHttpUri", httpExchange.getRequestURI());
        headersMap.put("CamelHttpQuery", httpExchange.getQueryString());
        headersMap.put("CamelHttpRawQuery", httpExchange.getQueryString());
    }

    private static String stripPath(HttpServerExchange httpExchange, Exchange exchange) {
        String path = httpExchange.getRequestPath();
        UndertowEndpoint endpoint = (UndertowEndpoint)exchange.getFromEndpoint();
        if (endpoint.getHttpURI() != null) {
            String match;
            String endpointPath = endpoint.getHttpURI().getPath();
            String matchPath = path.toLowerCase(Locale.US);
            if (matchPath.startsWith(match = endpointPath.toLowerCase(Locale.US))) {
                path = path.substring(endpointPath.length());
            }
        }
        return path;
    }

    @Override
    public void populateCamelHeaders(ClientResponse response, Map<String, Object> headersMap, Exchange exchange) {
        LOG.trace("populateCamelHeaders: {}", exchange.getMessage().getHeaders());
        headersMap.put("CamelHttpResponseCode", response.getResponseCode());
        for (HttpString name : response.getResponseHeaders().getHeaderNames()) {
            String value;
            if (name.toString().toLowerCase(Locale.US).equals("content-type")) {
                name = ExchangeHeaders.CONTENT_TYPE;
            }
            if (name.toString().toLowerCase(Locale.US).equals("authorization") && (value = response.getResponseHeaders().get(name).toString()) != null && value.trim().startsWith("Basic") && this.headerFilterStrategy != null && !this.headerFilterStrategy.applyFilterToExternalHeaders("CamelAuthentication", "Basic", exchange)) {
                UndertowHelper.appendHeader(headersMap, "CamelAuthentication", "Basic");
            }
            for (String value2 : response.getResponseHeaders().get(name)) {
                LOG.trace("HTTP-header: {}", (Object)value2);
                if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name.toString(), value2, exchange)) continue;
                UndertowHelper.appendHeader(headersMap, name.toString(), value2);
            }
        }
    }

    @Override
    public Object toHttpResponse(HttpServerExchange httpExchange, Message message) throws IOException {
        Exchange camelExchange = message.getExchange();
        Object body = message.getBody();
        Exception exception = camelExchange.getException();
        int code = HttpUtil.determineResponseCode(camelExchange, body);
        message.getHeaders().put("CamelHttpResponseCode", code);
        httpExchange.setStatusCode(code);
        TypeConverter tc = message.getExchange().getContext().getTypeConverter();
        for (Map.Entry<String, Object> entry : message.getHeaders().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            Iterator<?> it = ObjectHelper.createIterator(value, null);
            while (it.hasNext()) {
                String headerValue = tc.convertTo(String.class, it.next());
                if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, headerValue, camelExchange)) continue;
                LOG.trace("HTTP-Header: {}={}", (Object)key, (Object)headerValue);
                httpExchange.getResponseHeaders().add(new HttpString(key), headerValue);
            }
        }
        if (exception != null && !this.isMuteException().booleanValue()) {
            if (this.isTransferException().booleanValue()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(exception);
                oos.flush();
                IOHelper.close(oos, bos);
                body = ByteBuffer.wrap(bos.toByteArray());
                message.setHeader("Content-Type", "application/x-java-serialized-object");
            } else {
                String stackTrace = ExceptionHelper.stackTraceToString(exception);
                body = ByteBuffer.wrap(stackTrace.getBytes());
                message.setHeader("Content-Type", "text/plain");
            }
            ExchangeHelper.setFailureHandled(camelExchange);
        } else if (exception != null && this.isMuteException().booleanValue()) {
            ExchangeHelper.setFailureHandled(camelExchange);
        }
        String contentType = MessageHelper.getContentType(message);
        if (contentType != null) {
            httpExchange.getResponseHeaders().put(Headers.CONTENT_TYPE, contentType);
            LOG.trace("Content-Type: {}", (Object)contentType);
        }
        return body;
    }

    @Override
    public Object toHttpRequest(ClientRequest clientRequest, Message message) {
        Object body = message.getBody();
        HeaderMap requestHeaders = clientRequest.getRequestHeaders();
        String contentType = MessageHelper.getContentType(message);
        if (contentType != null) {
            requestHeaders.put(Headers.CONTENT_TYPE, contentType);
            LOG.trace("Content-Type: {}", (Object)contentType);
        }
        TypeConverter tc = message.getExchange().getContext().getTypeConverter();
        for (Map.Entry<String, Object> entry : message.getHeaders().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            Iterator<?> it = ObjectHelper.createIterator(value, null);
            while (it.hasNext()) {
                String headerValue = tc.convertTo(String.class, it.next());
                if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, headerValue, message.getExchange())) continue;
                LOG.trace("HTTP-Header: {}={}", (Object)key, (Object)headerValue);
                requestHeaders.add(new HttpString(key), headerValue);
            }
        }
        return body;
    }

    byte[] readFromChannel(StreamSourceChannel source) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteBuffer buffer = ByteBuffer.wrap(new byte[1024]);
        BlockingReadableByteChannel blockingSource = new BlockingReadableByteChannel(source);
        int res;
        while ((res = blockingSource.read(buffer)) != -1) {
            if (res == 0) {
                LOG.error("Channel did not block");
                continue;
            }
            BufferCaster.cast(buffer).flip();
            out.write(buffer.array(), buffer.arrayOffset() + BufferCaster.cast(buffer).position(), buffer.arrayOffset() + BufferCaster.cast(buffer).limit());
            BufferCaster.cast(buffer).clear();
        }
        return out.toByteArray();
    }

    static class FilePartDataSource
    extends FileDataSource {
        private final String name;
        private final String contentType;

        FilePartDataSource(FormData.FormValue value) {
            super(value.getPath().toFile());
            this.name = value.getFileName();
            this.contentType = value.getHeaders().getFirst(Headers.CONTENT_TYPE);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }
    }
}

