/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientRequest;
import io.undertow.client.UndertowClient;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.undertow.UndertowClientCallback;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.component.undertow.UndertowHelper;
import org.apache.camel.component.undertow.UndertowHttpBinding;
import org.apache.camel.component.undertow.UndertowStreamingClientCallback;
import org.apache.camel.component.undertow.handlers.CamelWebSocketHandler;
import org.apache.camel.http.base.cookie.CookieHandler;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.OptionMap;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

public class UndertowProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowProducer.class);
    private UndertowClient client;
    private final UndertowEndpoint endpoint;
    private final OptionMap options;
    private DefaultByteBufferPool pool;
    private XnioSsl ssl;
    private XnioWorker worker;
    private CamelWebSocketHandler webSocketHandler;

    public UndertowProducer(UndertowEndpoint endpoint, OptionMap options) {
        super(endpoint);
        this.endpoint = endpoint;
        this.options = options;
    }

    @Override
    public UndertowEndpoint getEndpoint() {
        return this.endpoint;
    }

    boolean isSendToAll(Message in) {
        Boolean value = in.getHeader("websocket.sendToAll", this.endpoint.getSendToAll(), Boolean.class);
        return value != null && value != false;
    }

    @Override
    public boolean process(Exchange camelExchange, AsyncCallback callback) {
        UndertowClientCallback clientCallback;
        Map<Object, Object> cookieHeaders;
        HttpString method;
        URI uri;
        if (this.endpoint.isWebSocket()) {
            return this.processWebSocket(camelExchange, callback);
        }
        try {
            String exchangeUri = UndertowHelper.createURL(camelExchange, this.getEndpoint());
            uri = UndertowHelper.createURI(camelExchange, exchangeUri, this.getEndpoint());
            method = UndertowHelper.createMethod(camelExchange, this.endpoint, camelExchange.getIn().getBody() != null);
        }
        catch (URISyntaxException e) {
            camelExchange.setException(e);
            callback.done(true);
            return true;
        }
        String pathAndQuery = URISupport.pathAndQueryOf(uri);
        UndertowHttpBinding undertowHttpBinding = this.endpoint.getUndertowHttpBinding();
        CookieHandler cookieHandler = this.endpoint.getCookieHandler();
        if (cookieHandler != null) {
            try {
                cookieHeaders = cookieHandler.loadCookies(camelExchange, uri);
            }
            catch (IOException e) {
                camelExchange.setException(e);
                callback.done(true);
                return true;
            }
        } else {
            cookieHeaders = Collections.emptyMap();
        }
        ClientRequest request = new ClientRequest();
        request.setMethod(method);
        request.setPath(pathAndQuery);
        HeaderMap requestHeaders = request.getRequestHeaders();
        Message message = camelExchange.getIn();
        String host = message.getHeader("Host", String.class);
        if (this.endpoint.isPreserveHostHeader()) {
            requestHeaders.put(Headers.HOST, Optional.ofNullable(host).orElseGet(uri::getAuthority));
        } else {
            requestHeaders.put(Headers.HOST, uri.getAuthority());
        }
        cookieHeaders.forEach((key, values) -> requestHeaders.putAll(HttpString.tryFromString(key), (Collection<String>)values));
        Object body = undertowHttpBinding.toHttpRequest(request, camelExchange.getIn());
        boolean streaming = this.getEndpoint().isUseStreaming();
        if (streaming && body instanceof InputStream) {
            requestHeaders.put(Headers.TRANSFER_ENCODING, "chunked");
            clientCallback = new UndertowStreamingClientCallback(camelExchange, callback, this.getEndpoint(), request, (InputStream)body);
        } else {
            TypeConverter tc = this.endpoint.getCamelContext().getTypeConverter();
            ByteBuffer bodyAsByte = tc.tryConvertTo(ByteBuffer.class, body);
            if (body != null && bodyAsByte != null) {
                requestHeaders.put(Headers.CONTENT_LENGTH, bodyAsByte.remaining());
            }
            clientCallback = streaming ? new UndertowStreamingClientCallback(camelExchange, callback, this.getEndpoint(), request, bodyAsByte) : new UndertowClientCallback(camelExchange, callback, this.getEndpoint(), request, bodyAsByte);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing http {} method: {}", (Object)method, (Object)pathAndQuery);
        }
        this.client.connect((ClientCallback<ClientConnection>)clientCallback, uri, this.worker, this.ssl, (ByteBufferPool)this.pool, this.options);
        return false;
    }

    private boolean processWebSocket(Exchange camelExchange, AsyncCallback camelCallback) {
        Message in = camelExchange.getIn();
        try {
            Object message = in.getBody();
            if (!(message instanceof String || message instanceof byte[] || message instanceof Reader || message instanceof InputStream)) {
                message = in.getBody(String.class);
            }
            if (message != null) {
                int timeout = this.endpoint.getSendTimeout();
                if (this.isSendToAll(in)) {
                    return this.webSocketHandler.send(peer -> true, message, timeout, camelExchange, camelCallback);
                }
                List connectionKeys = in.getHeader("websocket.connectionKey.list", List.class);
                if (connectionKeys != null) {
                    return this.webSocketHandler.send(peer -> connectionKeys.contains(peer.getAttribute("websocket.connectionKey")), message, timeout, camelExchange, camelCallback);
                }
                String connectionKey = in.getHeader("websocket.connectionKey", String.class);
                if (connectionKey != null) {
                    return this.webSocketHandler.send(peer -> connectionKey.equals(peer.getAttribute("websocket.connectionKey")), message, timeout, camelExchange, camelCallback);
                }
                throw new IllegalStateException(String.format("Cannot process message which has none of the headers %s, %s or %s set: %s", "websocket.sendToAll", "websocket.connectionKey.list", "websocket.connectionKey", in));
            }
            camelCallback.done(true);
            return true;
        }
        catch (Exception e) {
            camelExchange.setException(e);
            camelCallback.done(true);
            return true;
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.pool = new DefaultByteBufferPool(true, 17408);
        Xnio xnio = Xnio.getInstance();
        this.worker = xnio.createWorker(this.options);
        SSLContext sslContext = this.getEndpoint().getSslContext();
        if (sslContext != null) {
            this.ssl = new UndertowXnioSsl(xnio, this.options, sslContext);
        }
        this.client = UndertowClient.getInstance();
        if (this.endpoint.isWebSocket()) {
            this.webSocketHandler = (CamelWebSocketHandler)this.endpoint.getComponent().registerEndpoint(null, this.endpoint.getHttpHandlerRegistrationInfo(), this.endpoint.getSslContext(), new CamelWebSocketHandler());
        }
        LOG.debug("Created worker: {} with options: {}", (Object)this.worker, (Object)this.options);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.endpoint.isWebSocket()) {
            this.endpoint.getComponent().unregisterEndpoint(null, this.endpoint.getHttpHandlerRegistrationInfo(), this.endpoint.getSslContext());
        }
        if (this.worker != null && !this.worker.isShutdown()) {
            LOG.debug("Shutting down worker: {}", (Object)this.worker);
            this.worker.shutdown();
        }
    }
}

