/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathTemplateHandler;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.undertow.handlers.CamelMethodHandler;

public class CamelPathTemplateHandler
implements HttpHandler {
    private final Map<String, CamelMethodHandler> handlers = new HashMap<String, CamelMethodHandler>();
    private final Wrapper defaultHandlerWrapper = new Wrapper();
    private final PathTemplateHandler delegate;
    private String handlerString;

    public CamelPathTemplateHandler(CamelMethodHandler defaultHandler) {
        this.defaultHandlerWrapper.set(defaultHandler);
        this.delegate = new PathTemplateHandler(this.defaultHandlerWrapper);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        this.delegate.handleRequest(exchange);
    }

    public synchronized CamelPathTemplateHandler add(String uriTemplate, CamelMethodHandler handler) {
        this.delegate.add(uriTemplate, handler);
        this.handlers.put(uriTemplate, handler);
        this.handlerString = null;
        return this;
    }

    public synchronized CamelPathTemplateHandler remove(String uriTemplate) {
        this.delegate.remove(uriTemplate);
        this.handlers.remove(uriTemplate);
        this.handlerString = null;
        return this;
    }

    public CamelMethodHandler get(String uriTemplate) {
        return this.handlers.get(uriTemplate);
    }

    public boolean isEmpty() {
        return this.handlers.isEmpty();
    }

    public synchronized CamelMethodHandler getDefault() {
        return this.defaultHandlerWrapper.get();
    }

    public synchronized void setDefault(CamelMethodHandler defaultHandler) {
        this.defaultHandlerWrapper.set(defaultHandler);
        this.handlerString = null;
    }

    public String toString() {
        if (this.handlerString == null) {
            this.handlerString = "CamelPathTemplateHandler[default=" + this.defaultHandlerWrapper.get() + ", " + this.handlers + "]";
        }
        return this.handlerString;
    }

    static class Wrapper
    implements HttpHandler {
        private CamelMethodHandler handler;

        Wrapper() {
        }

        public void set(CamelMethodHandler handler) {
            this.handler = handler;
        }

        public CamelMethodHandler get() {
            return this.handler;
        }

        @Override
        public void handleRequest(HttpServerExchange exchange) throws Exception {
            this.handler.handleRequest(exchange);
        }
    }
}

