/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.websocket;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;

class VertxWebsocketResultHandler {
    private final Exchange exchange;
    private final AsyncCallback callback;
    private final Set<String> connectionKeys;
    private final Map<String, Throwable> errors = new HashMap<String, Throwable>();
    private final Object lock = new Object();

    VertxWebsocketResultHandler(Exchange exchange, AsyncCallback callback, Set<String> connectionKeys) {
        this.exchange = exchange;
        this.callback = callback;
        this.connectionKeys = new HashSet<String>(connectionKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onResult(String connectionKey) {
        Object object = this.lock;
        synchronized (object) {
            this.connectionKeys.remove(connectionKey);
            if (this.connectionKeys.isEmpty()) {
                this.onComplete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onError(String connectionKey, Throwable cause) {
        Object object = this.lock;
        synchronized (object) {
            this.errors.put(connectionKey, cause);
        }
    }

    private void onComplete() {
        if (!this.errors.isEmpty()) {
            if (this.errors.size() == 1) {
                Map.Entry<String, Throwable> entry = this.errors.entrySet().iterator().next();
                String msg = "Sending message to WebSocket peer for connection key " + entry.getKey() + " failed";
                this.exchange.setException(new CamelExecutionException(msg, this.exchange, entry.getValue()));
            } else {
                StringBuilder msg = new StringBuilder("Sending message to multiple WebSocket peers failed:");
                for (Map.Entry<String, Throwable> entry : this.errors.entrySet()) {
                    msg.append("\n  connection key: ").append(entry.getKey()).append(", cause: ").append(entry.getValue().getMessage());
                }
                this.exchange.setException(new CamelExecutionException(msg.toString(), this.exchange));
            }
        }
        this.callback.done(false);
    }
}

