/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.log.Logger;
import com.dylibso.chicory.log.SystemLogger;
import com.dylibso.chicory.runtime.ExecutionListener;
import com.dylibso.chicory.runtime.FromHost;
import com.dylibso.chicory.runtime.HostFunction;
import com.dylibso.chicory.runtime.HostGlobal;
import com.dylibso.chicory.runtime.HostImports;
import com.dylibso.chicory.runtime.HostMemory;
import com.dylibso.chicory.runtime.HostTable;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.InterpreterMachine;
import com.dylibso.chicory.runtime.Machine;
import com.dylibso.chicory.runtime.Memory;
import com.dylibso.chicory.runtime.ModuleType;
import com.dylibso.chicory.runtime.exceptions.WASMRuntimeException;
import com.dylibso.chicory.wasm.Parser;
import com.dylibso.chicory.wasm.exceptions.InvalidException;
import com.dylibso.chicory.wasm.exceptions.MalformedException;
import com.dylibso.chicory.wasm.exceptions.UnlinkableException;
import com.dylibso.chicory.wasm.types.DataSegment;
import com.dylibso.chicory.wasm.types.Element;
import com.dylibso.chicory.wasm.types.Export;
import com.dylibso.chicory.wasm.types.ExportSection;
import com.dylibso.chicory.wasm.types.ExternalType;
import com.dylibso.chicory.wasm.types.FunctionBody;
import com.dylibso.chicory.wasm.types.FunctionImport;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.Global;
import com.dylibso.chicory.wasm.types.GlobalImport;
import com.dylibso.chicory.wasm.types.Import;
import com.dylibso.chicory.wasm.types.MemorySection;
import com.dylibso.chicory.wasm.types.NameCustomSection;
import com.dylibso.chicory.wasm.types.Table;
import com.dylibso.chicory.wasm.types.TableImport;
import com.dylibso.chicory.wasm.types.ValueType;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class Module {
    public static final String START_FUNCTION_NAME = "_start";
    private final com.dylibso.chicory.wasm.Module module;
    private final Map<String, Export> exports;
    private final Logger logger;
    private final boolean initialize;
    private final boolean start;
    private final boolean typeValidation;
    private final ExecutionListener listener;
    private final HostImports hostImports;
    private final Function<Instance, Machine> machineFactory;

    private Module(com.dylibso.chicory.wasm.Module module, Logger logger, Function<Instance, Machine> machineFactory, HostImports hostImports, ExecutionListener listener, boolean initialize, boolean start, boolean typeValidation) {
        this.logger = logger;
        this.machineFactory = machineFactory;
        this.hostImports = hostImports;
        this.listener = listener;
        this.initialize = initialize;
        this.start = start;
        this.typeValidation = typeValidation;
        this.module = Module.validateModule(module);
        this.exports = Module.genExports(module.exportSection());
    }

    private static Map<String, Export> genExports(ExportSection export) {
        HashMap<String, Export> exports = new HashMap<String, Export>();
        int cnt = export.exportCount();
        for (int i = 0; i < cnt; ++i) {
            Export e = export.getExport(i);
            if (exports.containsKey(e.name())) {
                throw new InvalidException("duplicate export name " + e.name());
            }
            exports.put(e.name(), e);
        }
        return exports;
    }

    private static com.dylibso.chicory.wasm.Module validateModule(com.dylibso.chicory.wasm.Module module) {
        int functionSectionSize = module.functionSection().functionCount();
        int codeSectionSize = module.codeSection().functionBodyCount();
        int dataSectionSize = module.dataSection().dataSegmentCount();
        if (functionSectionSize != codeSectionSize) {
            throw new MalformedException("function and code section have inconsistent lengths");
        }
        if (module.dataCountSection() != null && dataSectionSize != module.dataCountSection().dataCount()) {
            throw new MalformedException("data count and data section have inconsistent lengths");
        }
        return module;
    }

    public Logger logger() {
        return this.logger;
    }

    public Instance instantiate() {
        Global[] globalInitializers = this.module.globalSection().globals();
        DataSegment[] dataSegments = this.module.dataSection().dataSegments();
        FunctionType[] types = this.module.typeSection().types();
        int numFuncTypes = this.module.functionSection().functionCount() + this.module.importSection().count(ExternalType.FUNCTION);
        FunctionBody[] functions = this.module.codeSection().functionBodies();
        int importId = 0;
        int[] functionTypes = new int[numFuncTypes];
        int funcIdx = 0;
        int importCount = this.module.importSection().importCount();
        Import[] imports = new Import[importCount];
        block15: for (int i = 0; i < importCount; ++i) {
            Import imprt = this.module.importSection().getImport(i);
            switch (imprt.importType()) {
                case FUNCTION: {
                    int type = ((FunctionImport)imprt).typeIndex();
                    if (type >= this.module.typeSection().typeCount()) {
                        throw new InvalidException("unknown type");
                    }
                    functionTypes[funcIdx] = type;
                    imports[importId++] = imprt;
                    ++funcIdx;
                    continue block15;
                }
                default: {
                    imports[importId++] = imprt;
                }
            }
        }
        HostImports mappedHostImports = this.mapHostImports(imports, this.hostImports);
        if (this.module.startSection() != null) {
            Export export = new Export(START_FUNCTION_NAME, (int)this.module.startSection().startIndex(), ExternalType.FUNCTION);
            this.exports.put(START_FUNCTION_NAME, export);
        }
        for (int i = 0; i < this.module.functionSection().functionCount(); ++i) {
            functionTypes[funcIdx++] = this.module.functionSection().getFunctionType(i);
        }
        int tableLength = this.module.tableSection().tableCount();
        Table[] tables = new Table[tableLength];
        for (int i = 0; i < tableLength; ++i) {
            tables[i] = this.module.tableSection().getTable(i);
        }
        Element[] elements = this.module.elementSection().elements();
        Memory memory = null;
        if (this.module.memorySection() != null) {
            MemorySection memories = this.module.memorySection();
            if (memories.memoryCount() + mappedHostImports.memoryCount() > 1) {
                throw new InvalidException("multiple memories are not supported");
            }
            if (memories.memoryCount() > 0) {
                memory = new Memory(memories.getMemory(0).memoryLimits());
            }
        } else if (mappedHostImports.memoryCount() > 0) {
            if (mappedHostImports.memoryCount() != 1) {
                throw new InvalidException("multiple memories");
            }
            if (mappedHostImports.memory(0) == null || mappedHostImports.memory(0).memory() == null) {
                throw new InvalidException("unknown memory, imported memory not defined, cannot run the program");
            }
            memory = mappedHostImports.memory(0).memory();
        }
        int globalImportsOffset = 0;
        int functionImportsOffset = 0;
        int tablesImportsOffset = 0;
        int memoryImportsOffset = 0;
        block18: for (int i = 0; i < imports.length; ++i) {
            switch (imports[i].importType()) {
                case GLOBAL: {
                    ++globalImportsOffset;
                    continue block18;
                }
                case FUNCTION: {
                    ++functionImportsOffset;
                    continue block18;
                }
                case TABLE: {
                    ++tablesImportsOffset;
                    continue block18;
                }
                case MEMORY: {
                    ++memoryImportsOffset;
                    continue block18;
                }
            }
        }
        for (Export e : this.exports.values()) {
            switch (e.exportType()) {
                case FUNCTION: {
                    if (e.index() < this.module.functionSection().functionCount() + functionImportsOffset) break;
                    throw new InvalidException("unknown function " + e.index());
                }
                case GLOBAL: {
                    if (e.index() < this.module.globalSection().globalCount() + globalImportsOffset) break;
                    throw new InvalidException("unknown global " + e.index());
                }
                case TABLE: {
                    if (e.index() < this.module.tableSection().tableCount() + tablesImportsOffset) break;
                    throw new InvalidException("unknown table " + e.index());
                }
                case MEMORY: {
                    int memoryCount;
                    int n = memoryCount = this.module.memorySection() == null ? 0 : this.module.memorySection().memoryCount();
                    if (e.index() < memoryCount + memoryImportsOffset) break;
                    throw new InvalidException("unknown memory " + e);
                }
            }
        }
        return new Instance(this, globalInitializers, globalImportsOffset, functionImportsOffset, tablesImportsOffset, memory, dataSegments, functions, types, functionTypes, mappedHostImports, tables, elements, this.machineFactory, this.initialize, this.start, this.typeValidation, this.listener);
    }

    private void validateHostFunctionSignature(FunctionImport imprt, HostFunction f) {
        ValueType got;
        ValueType expected;
        int i;
        FunctionType expectedType = this.module.typeSection().getType(imprt.typeIndex());
        if (expectedType.params().size() != f.paramTypes().size() || expectedType.returns().size() != f.returnTypes().size()) {
            throw new UnlinkableException("incompatible import type");
        }
        for (i = 0; i < expectedType.params().size(); ++i) {
            expected = expectedType.params().get(i);
            if (expected == (got = f.paramTypes().get(i))) continue;
            throw new UnlinkableException("incompatible import type");
        }
        for (i = 0; i < expectedType.returns().size(); ++i) {
            expected = expectedType.returns().get(i);
            if (expected == (got = f.returnTypes().get(i))) continue;
            throw new UnlinkableException("incompatible import type");
        }
    }

    private void validateHostGlobalType(GlobalImport i, HostGlobal g) {
        if (i.type() != g.instance().getValue().type() || i.mutabilityType() != g.mutabilityType()) {
            throw new UnlinkableException("incompatible import type");
        }
    }

    private void validateHostTableType(TableImport i, HostTable t) {
        if (i.entryType() != t.table().elementType()) {
            throw new UnlinkableException("incompatible import type");
        }
    }

    private void validateNegativeImportType(String moduleName, String name, FromHost[] fromHost) {
        for (FromHost fh : fromHost) {
            if (!fh.moduleName().equals(moduleName) || !fh.fieldName().equals(name)) continue;
            throw new UnlinkableException("incompatible import type");
        }
    }

    private void validateNegativeImportType(String moduleName, String name, ExternalType typ, HostImports hostImports) {
        switch (typ) {
            case FUNCTION: {
                this.validateNegativeImportType(moduleName, name, hostImports.globals());
                this.validateNegativeImportType(moduleName, name, hostImports.memories());
                this.validateNegativeImportType(moduleName, name, hostImports.tables());
                break;
            }
            case GLOBAL: {
                this.validateNegativeImportType(moduleName, name, hostImports.functions());
                this.validateNegativeImportType(moduleName, name, hostImports.memories());
                this.validateNegativeImportType(moduleName, name, hostImports.tables());
                break;
            }
            case MEMORY: {
                this.validateNegativeImportType(moduleName, name, hostImports.functions());
                this.validateNegativeImportType(moduleName, name, hostImports.globals());
                this.validateNegativeImportType(moduleName, name, hostImports.tables());
                break;
            }
            case TABLE: {
                this.validateNegativeImportType(moduleName, name, hostImports.functions());
                this.validateNegativeImportType(moduleName, name, hostImports.globals());
                this.validateNegativeImportType(moduleName, name, hostImports.memories());
            }
        }
    }

    private HostImports mapHostImports(Import[] imports, HostImports hostImports) {
        int hostFuncNum = 0;
        int hostGlobalNum = 0;
        int hostMemNum = 0;
        int hostTableNum = 0;
        block12: for (Import imprt : imports) {
            switch (imprt.importType()) {
                case FUNCTION: {
                    ++hostFuncNum;
                    continue block12;
                }
                case GLOBAL: {
                    ++hostGlobalNum;
                    continue block12;
                }
                case MEMORY: {
                    ++hostMemNum;
                    continue block12;
                }
                case TABLE: {
                    ++hostTableNum;
                }
            }
        }
        HostFunction[] hostFuncs = new HostFunction[hostFuncNum];
        int hostFuncIdx = 0;
        HostGlobal[] hostGlobals = new HostGlobal[hostGlobalNum];
        int hostGlobalIdx = 0;
        HostMemory[] hostMems = new HostMemory[hostMemNum];
        int hostMemIdx = 0;
        HostTable[] hostTables = new HostTable[hostTableNum];
        int hostTableIdx = 0;
        FromHost[] hostIndex = new FromHost[hostFuncNum + hostGlobalNum + hostMemNum + hostTableNum];
        for (int impIdx = 0; impIdx < imports.length; ++impIdx) {
            Import i = imports[impIdx];
            String name = i.moduleName() + "." + i.name();
            boolean found = false;
            this.validateNegativeImportType(i.moduleName(), i.name(), i.importType(), hostImports);
            switch (i.importType()) {
                case FUNCTION: {
                    int j;
                    int cnt = hostImports.functionCount();
                    for (j = 0; j < cnt; ++j) {
                        HostFunction f = hostImports.function(j);
                        if (!i.moduleName().equals(f.moduleName()) || !i.name().equals(f.fieldName())) continue;
                        this.validateHostFunctionSignature((FunctionImport)i, f);
                        hostFuncs[hostFuncIdx] = f;
                        hostIndex[impIdx] = f;
                        found = true;
                        break;
                    }
                    ++hostFuncIdx;
                    break;
                }
                case GLOBAL: {
                    int j;
                    int cnt = hostImports.globalCount();
                    for (j = 0; j < cnt; ++j) {
                        HostGlobal g = hostImports.global(j);
                        if (!i.moduleName().equals(g.moduleName()) || !i.name().equals(g.fieldName())) continue;
                        this.validateHostGlobalType((GlobalImport)i, g);
                        hostGlobals[hostGlobalIdx] = g;
                        hostIndex[impIdx] = g;
                        found = true;
                        break;
                    }
                    ++hostGlobalIdx;
                    break;
                }
                case MEMORY: {
                    int j;
                    int cnt = hostImports.memoryCount();
                    for (j = 0; j < cnt; ++j) {
                        HostMemory m = hostImports.memory(j);
                        if (!i.moduleName().equals(m.moduleName()) || !i.name().equals(m.fieldName())) continue;
                        hostMems[hostMemIdx] = m;
                        hostIndex[impIdx] = m;
                        found = true;
                        break;
                    }
                    ++hostMemIdx;
                    break;
                }
                case TABLE: {
                    int j;
                    int cnt = hostImports.tableCount();
                    for (j = 0; j < cnt; ++j) {
                        HostTable t = hostImports.table(j);
                        if (!i.moduleName().equals(t.moduleName()) || !i.name().equals(t.fieldName())) continue;
                        this.validateHostTableType((TableImport)i, t);
                        hostTables[hostTableIdx] = t;
                        hostIndex[impIdx] = t;
                        found = true;
                        break;
                    }
                    ++hostTableIdx;
                }
            }
            if (found) continue;
            this.logger.warnf("Could not find host function for import number: %d named %s", impIdx, name);
        }
        HostImports result = new HostImports(hostFuncs, hostGlobals, hostMems, hostTables);
        result.setIndex(hostIndex);
        return result;
    }

    public Export export(String name) {
        return this.exports.get(name);
    }

    public Map<String, Export> exports() {
        return this.exports;
    }

    public NameCustomSection nameSection() {
        return this.module.nameSection();
    }

    public com.dylibso.chicory.wasm.Module wasmModule() {
        return this.module;
    }

    public static Builder builder(InputStream input) {
        return new Builder(() -> input);
    }

    public static Builder builder(com.dylibso.chicory.wasm.Module wasmModule) {
        return new Builder(wasmModule);
    }

    public static Builder builder(ByteBuffer buffer) {
        return Module.builder(buffer.array());
    }

    public static Builder builder(byte[] buffer) {
        return new Builder(() -> new ByteArrayInputStream(buffer));
    }

    public static Builder builder(File file) {
        return new Builder(() -> {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("File not found at path: " + file.getPath(), e);
            }
        });
    }

    public static Builder builder(String classpathResource) {
        return new Builder(() -> {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathResource);
            if (is == null) {
                throw new IllegalArgumentException("Resource not found at classpath: " + classpathResource);
            }
            return is;
        });
    }

    public static Builder builder(Path path) {
        return new Builder(() -> {
            try {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error opening file: " + path, e);
            }
        });
    }

    public static class Builder {
        private final com.dylibso.chicory.wasm.Module parsed;
        private final Supplier<InputStream> inputStreamSupplier;
        private Logger logger;
        private ModuleType moduleType;
        private boolean initialize = true;
        private boolean start = true;
        private boolean typeValidation = true;
        private ExecutionListener listener = null;
        private HostImports hostImports = null;
        private Function<Instance, Machine> machineFactory = null;

        private Builder(Supplier<InputStream> inputStreamSupplier) {
            this.inputStreamSupplier = Objects.requireNonNull(inputStreamSupplier);
            this.parsed = null;
            this.moduleType = ModuleType.BINARY;
        }

        private Builder(com.dylibso.chicory.wasm.Module parsed) {
            this.parsed = Objects.requireNonNull(parsed);
            this.inputStreamSupplier = null;
            this.moduleType = ModuleType.BINARY;
        }

        public Builder withLogger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder withType(ModuleType type) {
            this.moduleType = type;
            return this;
        }

        public Builder withInitialize(boolean init) {
            this.initialize = init;
            return this;
        }

        public Builder withStart(boolean s) {
            this.start = s;
            return this;
        }

        public Builder withTypeValidation(boolean v) {
            this.typeValidation = v;
            return this;
        }

        public Builder withUnsafeExecutionListener(ExecutionListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder withHostImports(HostImports hostImports) {
            this.hostImports = hostImports;
            return this;
        }

        public Builder withMachineFactory(Function<Instance, Machine> machineFactory) {
            this.machineFactory = machineFactory;
            return this;
        }

        public Module build() {
            Logger logger = this.logger != null ? this.logger : new SystemLogger();
            HostImports hostImports = this.hostImports != null ? this.hostImports : new HostImports();
            Function<Instance, Machine> machineFactory = this.machineFactory != null ? this.machineFactory : InterpreterMachine::new;
            Parser parser = new Parser(logger);
            com.dylibso.chicory.wasm.Module parsed = this.parsed;
            if (parsed == null) {
                try (InputStream is = this.inputStreamSupplier.get();){
                    parsed = parser.parseModule(is);
                }
                catch (IOException e) {
                    throw new WASMRuntimeException(e);
                }
            }
            switch (this.moduleType) {
                case BINARY: {
                    return new Module(parsed, logger, machineFactory, hostImports, this.listener, this.initialize, this.start, this.typeValidation);
                }
            }
            throw new InvalidException("Text format parsing is not implemented, but you can use wat2wasm through Chicory.");
        }
    }
}

