/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wasm;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.wasm.WasmConfiguration;
import org.apache.camel.component.wasm.WasmEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@Component(value="wasm")
public class WasmComponent
extends DefaultComponent {
    @Metadata
    private WasmConfiguration configuration = new WasmConfiguration();

    public WasmComponent() {
        this(null);
    }

    public WasmComponent(CamelContext context) {
        super(context);
    }

    public String getModule() {
        return this.configuration.getModule();
    }

    public void setModule(String resource) {
        this.configuration.setModule(resource);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (ObjectHelper.isEmpty(remaining)) {
            throw new IllegalArgumentException("Expecting URI in the form of: 'wasm:functionName', got '" + uri + "'");
        }
        WasmConfiguration configuration = this.configuration.copy();
        WasmEndpoint endpoint = new WasmEndpoint(uri, this, remaining, configuration);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }
}

