/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionArbiter;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableRepeat<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long count;

    public FlowableRepeat(Flowable<T> source2, long count) {
        super(source2);
        this.count = count;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        SubscriptionArbiter sa = new SubscriptionArbiter();
        s.onSubscribe(sa);
        RepeatSubscriber<T> rs = new RepeatSubscriber<T>(s, this.count != Long.MAX_VALUE ? this.count - 1L : Long.MAX_VALUE, sa, this.source);
        rs.subscribeNext();
    }

    static final class RepeatSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -7098360935104053232L;
        final Subscriber<? super T> downstream;
        final SubscriptionArbiter sa;
        final Publisher<? extends T> source;
        long remaining;
        long produced;

        RepeatSubscriber(Subscriber<? super T> actual, long count, SubscriptionArbiter sa, Publisher<? extends T> source2) {
            this.downstream = actual;
            this.sa = sa;
            this.source = source2;
            this.remaining = count;
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.sa.setSubscription(s);
        }

        @Override
        public void onNext(T t) {
            ++this.produced;
            this.downstream.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            long r = this.remaining;
            if (r != Long.MAX_VALUE) {
                this.remaining = r - 1L;
            }
            if (r != 0L) {
                this.subscribeNext();
            } else {
                this.downstream.onComplete();
            }
        }

        void subscribeNext() {
            block3: {
                if (this.getAndIncrement() != 0) break block3;
                int missed = 1;
                do {
                    if (this.sa.isCancelled()) {
                        return;
                    }
                    long p = this.produced;
                    if (p != 0L) {
                        this.produced = 0L;
                        this.sa.produced(p);
                    }
                    this.source.subscribe(this);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

