/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.mixed;

import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.mixed.ScalarXMapZHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableSwitchMapMaybe<T, R>
extends Observable<R> {
    final Observable<T> source;
    final Function<? super T, ? extends MaybeSource<? extends R>> mapper;
    final boolean delayErrors;

    public ObservableSwitchMapMaybe(Observable<T> source2, Function<? super T, ? extends MaybeSource<? extends R>> mapper, boolean delayErrors) {
        this.source = source2;
        this.mapper = mapper;
        this.delayErrors = delayErrors;
    }

    @Override
    protected void subscribeActual(Observer<? super R> observer) {
        if (!ScalarXMapZHelper.tryAsMaybe(this.source, this.mapper, observer)) {
            this.source.subscribe(new SwitchMapMaybeMainObserver<T, R>(observer, this.mapper, this.delayErrors));
        }
    }

    static final class SwitchMapMaybeMainObserver<T, R>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -5402190102429853762L;
        final Observer<? super R> downstream;
        final Function<? super T, ? extends MaybeSource<? extends R>> mapper;
        final boolean delayErrors;
        final AtomicThrowable errors;
        final AtomicReference<SwitchMapMaybeObserver<R>> inner;
        static final SwitchMapMaybeObserver<Object> INNER_DISPOSED = new SwitchMapMaybeObserver(null);
        Disposable upstream;
        volatile boolean done;
        volatile boolean cancelled;

        SwitchMapMaybeMainObserver(Observer<? super R> downstream, Function<? super T, ? extends MaybeSource<? extends R>> mapper, boolean delayErrors) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
            this.inner = new AtomicReference();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            MaybeSource<R> ms;
            SwitchMapMaybeObserver<R> current = this.inner.get();
            if (current != null) {
                current.dispose();
            }
            try {
                ms = ObjectHelper.requireNonNull(this.mapper.apply(t), "The mapper returned a null MaybeSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.upstream.dispose();
                this.inner.getAndSet(INNER_DISPOSED);
                this.onError(ex);
                return;
            }
            SwitchMapMaybeObserver observer = new SwitchMapMaybeObserver(this);
            while ((current = this.inner.get()) != INNER_DISPOSED) {
                if (!this.inner.compareAndSet(current, observer)) continue;
                ms.subscribe(observer);
                break;
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.errors.addThrowable(t)) {
                if (!this.delayErrors) {
                    this.disposeInner();
                }
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void disposeInner() {
            SwitchMapMaybeObserver<Object> current = this.inner.getAndSet(INNER_DISPOSED);
            if (current != null && current != INNER_DISPOSED) {
                current.dispose();
            }
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            this.upstream.dispose();
            this.disposeInner();
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void innerError(SwitchMapMaybeObserver<R> sender, Throwable ex) {
            if (this.inner.compareAndSet(sender, null) && this.errors.addThrowable(ex)) {
                if (!this.delayErrors) {
                    this.upstream.dispose();
                    this.disposeInner();
                }
                this.drain();
                return;
            }
            RxJavaPlugins.onError(ex);
        }

        void innerComplete(SwitchMapMaybeObserver<R> sender) {
            if (this.inner.compareAndSet(sender, null)) {
                this.drain();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer<R> downstream = this.downstream;
            AtomicThrowable errors = this.errors;
            AtomicReference<SwitchMapMaybeObserver<R>> inner = this.inner;
            while (true) {
                boolean empty2;
                if (this.cancelled) {
                    return;
                }
                if (errors.get() != null && !this.delayErrors) {
                    Throwable ex = errors.terminate();
                    downstream.onError(ex);
                    return;
                }
                boolean d = this.done;
                SwitchMapMaybeObserver<R> current = inner.get();
                boolean bl = empty2 = current == null;
                if (d && empty2) {
                    Throwable ex = errors.terminate();
                    if (ex != null) {
                        downstream.onError(ex);
                    } else {
                        downstream.onComplete();
                    }
                    return;
                }
                if (!empty2 && current.item != null) {
                    inner.compareAndSet(current, null);
                    downstream.onNext(current.item);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        static final class SwitchMapMaybeObserver<R>
        extends AtomicReference<Disposable>
        implements MaybeObserver<R> {
            private static final long serialVersionUID = 8042919737683345351L;
            final SwitchMapMaybeMainObserver<?, R> parent;
            volatile R item;

            SwitchMapMaybeObserver(SwitchMapMaybeMainObserver<?, R> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onSuccess(R t) {
                this.item = t;
                this.parent.drain();
            }

            @Override
            public void onError(Throwable e) {
                this.parent.innerError(this, e);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete(this);
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

