/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.RuntimeCamelException;

public class TypeConversionException
extends RuntimeCamelException {
    private final transient Object value;
    private final transient Class<?> type;

    public TypeConversionException(Object value, Class<?> type2, Throwable cause) {
        super(TypeConversionException.createMessage(value, type2, cause), cause);
        this.value = value;
        this.type = type2;
    }

    public Object getValue() {
        return this.value;
    }

    public Class<?> getToType() {
        return this.type;
    }

    public Class<?> getFromType() {
        if (this.value != null) {
            return this.value.getClass();
        }
        return null;
    }

    public static String createMessage(Object value, Class<?> type2, Throwable cause) {
        return "Error during type conversion from type: " + (value != null ? value.getClass().getCanonicalName() : null) + " to the required type: " + type2.getCanonicalName() + " with value " + String.valueOf(value) + " due to " + cause.getClass().getName() + ": " + cause.getMessage();
    }
}

