/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.catalog.PropertiesValidationResult;

public class ConfigurationPropertiesValidationResult
extends PropertiesValidationResult
implements Serializable {
    private String fileName;
    private String text;
    private int lineNumber;
    private boolean accepted;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    public String summaryErrorMessage(boolean includeHeader) {
        return this.summaryErrorMessage(includeHeader, true, false);
    }

    public String summaryErrorMessage(boolean includeHeader, boolean ignoreDeprecated, boolean includeWarnings) {
        boolean ok = this.isSuccess();
        if (ok && !ignoreDeprecated) {
            boolean bl = ok = this.deprecated == null;
        }
        if (includeWarnings && this.unknownComponent != null) {
            return "\tUnknown component: " + this.unknownComponent;
        }
        if (ok) {
            return null;
        }
        LinkedHashMap<String, Object> options2 = new LinkedHashMap<String, Object>();
        if (this.unknown != null) {
            for (String string : this.unknown) {
                if (this.unknownSuggestions != null && this.unknownSuggestions.containsKey(string)) {
                    String[] suggestions = (String[])this.unknownSuggestions.get(string);
                    if (suggestions != null && suggestions.length > 0) {
                        String str = Arrays.asList(suggestions).toString();
                        options2.put(string, "Unknown option. Did you mean: " + str);
                        continue;
                    }
                    options2.put(string, "Unknown option");
                    continue;
                }
                options2.put(string, "Unknown option");
            }
        }
        if (this.required != null) {
            for (String string : this.required) {
                options2.put(string, "Missing required option");
            }
        }
        if (this.deprecated != null) {
            for (String string : this.deprecated) {
                options2.put(string, "Deprecated option");
            }
        }
        if (this.invalidEnum != null) {
            for (Map.Entry entry : this.invalidEnum.entrySet()) {
                String[] suggestions;
                String name = (String)entry.getKey();
                String[] choices = (String[])this.invalidEnumChoices.get(name);
                String defaultValue = this.defaultValues != null ? (String)this.defaultValues.get(entry.getKey()) : null;
                String str = Arrays.asList(choices).toString();
                String msg = "Invalid enum value: " + (String)entry.getValue() + ". Possible values: " + str;
                if (this.invalidEnumSuggestions != null && (suggestions = (String[])this.invalidEnumSuggestions.get(name)) != null && suggestions.length > 0) {
                    str = Arrays.asList(suggestions).toString();
                    msg = msg + ". Did you mean: " + str;
                }
                if (defaultValue != null) {
                    msg = msg + ". Default value: " + defaultValue;
                }
                options2.put((String)entry.getKey(), msg);
            }
        }
        if (this.invalidReference != null) {
            for (Map.Entry entry : this.invalidReference.entrySet()) {
                boolean empty2 = ConfigurationPropertiesValidationResult.isEmpty((String)entry.getValue());
                if (empty2) {
                    options2.put((String)entry.getKey(), "Empty reference value");
                    continue;
                }
                if (!((String)entry.getValue()).startsWith("#")) {
                    options2.put((String)entry.getKey(), "Invalid reference value: " + (String)entry.getValue() + " must start with #");
                    continue;
                }
                options2.put((String)entry.getKey(), "Invalid reference value: " + (String)entry.getValue());
            }
        }
        if (this.invalidBoolean != null) {
            for (Map.Entry entry : this.invalidBoolean.entrySet()) {
                boolean empty3 = ConfigurationPropertiesValidationResult.isEmpty((String)entry.getValue());
                if (empty3) {
                    options2.put((String)entry.getKey(), "Empty boolean value");
                    continue;
                }
                options2.put((String)entry.getKey(), "Invalid boolean value: " + (String)entry.getValue());
            }
        }
        if (this.invalidInteger != null) {
            for (Map.Entry entry : this.invalidInteger.entrySet()) {
                boolean empty4 = ConfigurationPropertiesValidationResult.isEmpty((String)entry.getValue());
                if (empty4) {
                    options2.put((String)entry.getKey(), "Empty integer value");
                    continue;
                }
                options2.put((String)entry.getKey(), "Invalid integer value: " + (String)entry.getValue());
            }
        }
        if (this.invalidNumber != null) {
            for (Map.Entry entry : this.invalidNumber.entrySet()) {
                boolean empty5 = ConfigurationPropertiesValidationResult.isEmpty((String)entry.getValue());
                if (empty5) {
                    options2.put((String)entry.getKey(), "Empty number value");
                    continue;
                }
                options2.put((String)entry.getKey(), "Invalid number value: " + (String)entry.getValue());
            }
        }
        if (this.invalidMap != null) {
            for (Map.Entry entry : this.invalidMap.entrySet()) {
                boolean empty6 = ConfigurationPropertiesValidationResult.isEmpty((String)entry.getValue());
                if (empty6) {
                    options2.put((String)entry.getKey(), "Empty map key/value pair");
                    continue;
                }
                options2.put((String)entry.getKey(), "Invalid map key/value: " + (String)entry.getValue());
            }
        }
        if (this.invalidArray != null) {
            for (Map.Entry entry : this.invalidArray.entrySet()) {
                boolean empty7 = ConfigurationPropertiesValidationResult.isEmpty((String)entry.getValue());
                if (empty7) {
                    options2.put((String)entry.getKey(), "Empty array index/value pair");
                    continue;
                }
                options2.put((String)entry.getKey(), "Invalid array index/value: " + (String)entry.getValue());
            }
        }
        int maxLen = 24;
        for (String key : options2.keySet()) {
            maxLen = Math.max(maxLen, key.length());
        }
        String string = "%" + maxLen + "s    %s";
        StringBuilder sb = new StringBuilder();
        if (includeHeader) {
            sb.append("Configuration properties error\n");
            sb.append("---------------------------------------------------------------------------------------------------------------------------------------\n");
            sb.append("\n");
        }
        if (this.text != null) {
            sb.append("\t").append(this.text).append("\n");
        } else {
            sb.append("\n");
        }
        for (Map.Entry option : options2.entrySet()) {
            String out = String.format(string, ConfigurationPropertiesValidationResult.shortKey((String)option.getKey()), option.getValue());
            sb.append("\n\t").append(out);
        }
        return sb.toString();
    }

    private static String shortKey(String key) {
        if (key.indexOf(46) > 0) {
            return key.substring(key.lastIndexOf(46) + 1);
        }
        return key;
    }
}

