/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.web3j;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Message;
import org.apache.camel.component.web3j.Web3jConfiguration;
import org.apache.camel.component.web3j.Web3jEndpoint;
import org.apache.camel.component.web3j.Web3jHelper;
import org.apache.camel.spi.InvokeOnHeader;
import org.apache.camel.support.HeaderSelectorProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.Response;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.request.ShhFilter;
import org.web3j.protocol.core.methods.request.ShhPost;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.DbGetHex;
import org.web3j.protocol.core.methods.response.DbGetString;
import org.web3j.protocol.core.methods.response.DbPutHex;
import org.web3j.protocol.core.methods.response.DbPutString;
import org.web3j.protocol.core.methods.response.EthAccounts;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.EthBlockNumber;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthCoinbase;
import org.web3j.protocol.core.methods.response.EthCompileLLL;
import org.web3j.protocol.core.methods.response.EthCompileSerpent;
import org.web3j.protocol.core.methods.response.EthCompileSolidity;
import org.web3j.protocol.core.methods.response.EthEstimateGas;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthGetBlockTransactionCountByHash;
import org.web3j.protocol.core.methods.response.EthGetBlockTransactionCountByNumber;
import org.web3j.protocol.core.methods.response.EthGetCode;
import org.web3j.protocol.core.methods.response.EthGetCompilers;
import org.web3j.protocol.core.methods.response.EthGetStorageAt;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthGetUncleCountByBlockHash;
import org.web3j.protocol.core.methods.response.EthGetUncleCountByBlockNumber;
import org.web3j.protocol.core.methods.response.EthGetWork;
import org.web3j.protocol.core.methods.response.EthHashrate;
import org.web3j.protocol.core.methods.response.EthLog;
import org.web3j.protocol.core.methods.response.EthMining;
import org.web3j.protocol.core.methods.response.EthProtocolVersion;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.EthSign;
import org.web3j.protocol.core.methods.response.EthSubmitHashrate;
import org.web3j.protocol.core.methods.response.EthSubmitWork;
import org.web3j.protocol.core.methods.response.EthSyncing;
import org.web3j.protocol.core.methods.response.EthTransaction;
import org.web3j.protocol.core.methods.response.EthUninstallFilter;
import org.web3j.protocol.core.methods.response.NetListening;
import org.web3j.protocol.core.methods.response.NetPeerCount;
import org.web3j.protocol.core.methods.response.NetVersion;
import org.web3j.protocol.core.methods.response.ShhAddToGroup;
import org.web3j.protocol.core.methods.response.ShhHasIdentity;
import org.web3j.protocol.core.methods.response.ShhMessages;
import org.web3j.protocol.core.methods.response.ShhNewFilter;
import org.web3j.protocol.core.methods.response.ShhNewGroup;
import org.web3j.protocol.core.methods.response.ShhNewIdentity;
import org.web3j.protocol.core.methods.response.ShhUninstallFilter;
import org.web3j.protocol.core.methods.response.ShhVersion;
import org.web3j.protocol.core.methods.response.Web3ClientVersion;
import org.web3j.protocol.core.methods.response.Web3Sha3;
import org.web3j.protocol.core.methods.response.admin.AdminNodeInfo;
import org.web3j.quorum.Quorum;
import org.web3j.quorum.methods.request.PrivateTransaction;
import org.web3j.quorum.methods.response.PrivatePayload;

public class Web3jProducer
extends HeaderSelectorProducer {
    private static final Logger LOG = LoggerFactory.getLogger(Web3jProducer.class);
    private final Web3j web3j;
    private Quorum quorum;
    private final Web3jConfiguration configuration;

    public Web3jProducer(Web3jEndpoint endpoint, Web3jConfiguration configuration) {
        super((Endpoint)endpoint, "OPERATION", configuration::getOperationOrDefault);
        this.web3j = endpoint.getWeb3j();
        this.configuration = configuration;
        if (this.web3j instanceof Quorum) {
            this.quorum = (Quorum)this.web3j;
        }
    }

    @Override
    public Web3jEndpoint getEndpoint() {
        return (Web3jEndpoint)super.getEndpoint();
    }

    @InvokeOnHeader(value="WEB3_CLIENT_VERSION")
    void web3ClientVersion(Message message) throws IOException {
        Request<?, Web3ClientVersion> web3ClientVersionRequest = this.web3j.web3ClientVersion();
        this.setRequestId(message, web3ClientVersionRequest);
        Web3ClientVersion response = web3ClientVersionRequest.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getWeb3ClientVersion());
        }
    }

    @InvokeOnHeader(value="WEB3_SHA3")
    void web3Sha3(Message message) throws IOException {
        Request<?, Web3Sha3> web3Sha3Request = this.web3j.web3Sha3(message.getBody(String.class));
        this.setRequestId(message, web3Sha3Request);
        Web3Sha3 response = web3Sha3Request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getResult());
        }
    }

    @InvokeOnHeader(value="NET_VERSION")
    void netVersion(Message message) throws IOException {
        Request<?, NetVersion> netVersionRequest = this.web3j.netVersion();
        this.setRequestId(message, netVersionRequest);
        NetVersion response = netVersionRequest.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getNetVersion());
        }
    }

    @InvokeOnHeader(value="NET_LISTENING")
    void netListening(Message message) throws IOException {
        Request<?, NetListening> netListeningRequest = this.web3j.netListening();
        this.setRequestId(message, netListeningRequest);
        NetListening response = netListeningRequest.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.isListening());
        }
    }

    @InvokeOnHeader(value="NET_PEER_COUNT")
    void netPeerCount(Message message) throws IOException {
        Request<?, NetPeerCount> request = this.web3j.netPeerCount();
        this.setRequestId(message, request);
        NetPeerCount response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getQuantity());
        }
    }

    @InvokeOnHeader(value="ethProtocolVersion")
    void ethProtocolVersion(Message message) throws IOException {
        Request<?, EthProtocolVersion> request = this.web3j.ethProtocolVersion();
        this.setRequestId(message, request);
        EthProtocolVersion response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getProtocolVersion());
        }
    }

    @InvokeOnHeader(value="ETH_SYNCING")
    void ethSyncing(Message message) throws IOException {
        Request<?, EthSyncing> request = this.web3j.ethSyncing();
        this.setRequestId(message, request);
        EthSyncing response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.isSyncing());
        }
    }

    @InvokeOnHeader(value="ETH_COINBASE")
    void ethCoinbase(Message message) throws IOException {
        Request<?, EthCoinbase> request = this.web3j.ethCoinbase();
        this.setRequestId(message, request);
        EthCoinbase response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getAddress());
        }
    }

    @InvokeOnHeader(value="ETH_MINING")
    void ethMining(Message message) throws IOException {
        Request<?, EthMining> request = this.web3j.ethMining();
        this.setRequestId(message, request);
        EthMining response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.isMining());
        }
    }

    @InvokeOnHeader(value="ETH_HASHRATE")
    void ethHashrate(Message message) throws IOException {
        Request<?, EthHashrate> request = this.web3j.ethHashrate();
        this.setRequestId(message, request);
        EthHashrate response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getHashrate());
        }
    }

    @InvokeOnHeader(value="ETH_GAS_PRICE")
    void ethGasPrice(Message message) throws IOException {
        Request<?, EthGasPrice> request = this.web3j.ethGasPrice();
        this.setRequestId(message, request);
        EthGasPrice response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getGasPrice());
        }
    }

    @InvokeOnHeader(value="ETH_ACCOUNTS")
    void ethAccounts(Message message) throws IOException {
        Request<?, EthAccounts> request = this.web3j.ethAccounts();
        this.setRequestId(message, request);
        EthAccounts response = request.send();
        message.setBody(response.getAccounts());
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getAccounts());
        }
    }

    @InvokeOnHeader(value="ETH_BLOCK_NUMBER")
    void ethBlockNumber(Message message) throws IOException {
        Request<?, EthBlockNumber> request = this.web3j.ethBlockNumber();
        this.setRequestId(message, request);
        EthBlockNumber response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getBlockNumber());
        }
    }

    @InvokeOnHeader(value="ETH_GET_BALANCE")
    void ethGetBalance(Message message) throws IOException {
        String address = message.getHeader("ADDRESS", this.configuration::getAddress, String.class);
        DefaultBlockParameter atBlock = Web3jHelper.toDefaultBlockParameter(message.getHeader("AT_BLOCK", this.configuration::getAtBlock, String.class));
        Request<?, EthGetBalance> request = this.web3j.ethGetBalance(address, atBlock);
        this.setRequestId(message, request);
        EthGetBalance response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getBalance());
        }
    }

    @InvokeOnHeader(value="ETH_GET_STORAGE_AT")
    void ethGetStorageAt(Message message) throws IOException {
        String address = message.getHeader("ADDRESS", this.configuration::getAddress, String.class);
        DefaultBlockParameter atBlock = Web3jHelper.toDefaultBlockParameter(message.getHeader("AT_BLOCK", this.configuration::getAtBlock, String.class));
        BigInteger position = message.getHeader("POSITION", this.configuration::getPosition, BigInteger.class);
        Request<?, EthGetStorageAt> request = this.web3j.ethGetStorageAt(address, position, atBlock);
        this.setRequestId(message, request);
        EthGetStorageAt response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getData());
        }
    }

    @InvokeOnHeader(value="ETH_GET_TRANSACTION_COUNT")
    void ethGetTransactionCount(Message message) throws IOException {
        String address = message.getHeader("ADDRESS", this.configuration::getAddress, String.class);
        DefaultBlockParameter atBlock = Web3jHelper.toDefaultBlockParameter(message.getHeader("AT_BLOCK", this.configuration::getAtBlock, String.class));
        Request<?, EthGetTransactionCount> request = this.web3j.ethGetTransactionCount(address, atBlock);
        this.setRequestId(message, request);
        EthGetTransactionCount response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getTransactionCount());
        }
    }

    @InvokeOnHeader(value="ETH_GET_BLOCK_TRANSACTION_COUNT_BY_HASH")
    void ethGetBlockTransactionCountByHash(Message message) throws IOException {
        String blockHash = message.getHeader("BLOCK_HASH", this.configuration::getBlockHash, String.class);
        Request<?, EthGetBlockTransactionCountByHash> request = this.web3j.ethGetBlockTransactionCountByHash(blockHash);
        this.setRequestId(message, request);
        EthGetBlockTransactionCountByHash response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getTransactionCount());
        }
    }

    @InvokeOnHeader(value="ETH_GET_BLOCK_TRANSACTION_COUNT_BY_NUMBER")
    void ethGetBlockTransactionCountByNumber(Message message) throws IOException {
        DefaultBlockParameter atBlock = Web3jHelper.toDefaultBlockParameter(message.getHeader("AT_BLOCK", this.configuration::getAtBlock, String.class));
        Request<?, EthGetBlockTransactionCountByNumber> request = this.web3j.ethGetBlockTransactionCountByNumber(atBlock);
        this.setRequestId(message, request);
        EthGetBlockTransactionCountByNumber response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getTransactionCount());
        }
    }

    @InvokeOnHeader(value="ETH_GET_UNCLE_COUNT_BY_BLOCK_HASH")
    void ethGetUncleCountByBlockHash(Message message) throws IOException {
        String blockHash = message.getHeader("BLOCK_HASH", this.configuration::getBlockHash, String.class);
        Request<?, EthGetUncleCountByBlockHash> request = this.web3j.ethGetUncleCountByBlockHash(blockHash);
        this.setRequestId(message, request);
        EthGetUncleCountByBlockHash response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getUncleCount());
        }
    }

    @InvokeOnHeader(value="ETH_GET_UNCLE_COUNT_BY_BLOCK_NUMBER")
    void ethGetUncleCountByBlockNumber(Message message) throws IOException {
        DefaultBlockParameter atBlock = Web3jHelper.toDefaultBlockParameter(message.getHeader("AT_BLOCK", this.configuration::getAtBlock, String.class));
        Request<?, EthGetUncleCountByBlockNumber> request = this.web3j.ethGetUncleCountByBlockNumber(atBlock);
        this.setRequestId(message, request);
        EthGetUncleCountByBlockNumber response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getUncleCount());
        }
    }

    @InvokeOnHeader(value="ETH_GET_CODE")
    void ethGetCode(Message message) throws IOException {
        DefaultBlockParameter atBlock = Web3jHelper.toDefaultBlockParameter(message.getHeader("AT_BLOCK", this.configuration::getAtBlock, String.class));
        String address = message.getHeader("ADDRESS", this.configuration::getAddress, String.class);
        Request<?, EthGetCode> request = this.web3j.ethGetCode(address, atBlock);
        this.setRequestId(message, request);
        EthGetCode response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getCode());
        }
    }

    @InvokeOnHeader(value="ETH_SIGN")
    void ethSign(Message message) throws IOException {
        String address = message.getHeader("ADDRESS", this.configuration::getAddress, String.class);
        String sha3HashOfDataToSign = message.getHeader("SHA3_HASH_OF_DATA_TO_SIGN", this.configuration::getSha3HashOfDataToSign, String.class);
        Request<?, EthSign> request = this.web3j.ethSign(address, sha3HashOfDataToSign);
        this.setRequestId(message, request);
        EthSign response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getSignature());
        }
    }

    @InvokeOnHeader(value="ETH_SEND_TRANSACTION")
    void ethSendTransaction(Message message) throws IOException {
        String fromAddress = message.getHeader("FROM_ADDRESS", this.configuration::getFromAddress, String.class);
        String toAddress = message.getHeader("TO_ADDRESS", this.configuration::getToAddress, String.class);
        BigInteger nonce = message.getHeader("NONCE", this.configuration::getNonce, BigInteger.class);
        BigInteger gasPrice = message.getHeader("GAS_PRICE", this.configuration::getGasPrice, BigInteger.class);
        BigInteger gasLimit = message.getHeader("GAS_LIMIT", this.configuration::getGasLimit, BigInteger.class);
        BigInteger value = message.getHeader("VALUE", this.configuration::getValue, BigInteger.class);
        String data2 = message.getHeader("DATA", this.configuration::getData, String.class);
        Transaction transaction = new Transaction(fromAddress, nonce, gasPrice, gasLimit, toAddress, value, data2);
        Request<?, EthSendTransaction> request = this.web3j.ethSendTransaction(transaction);
        this.setRequestId(message, request);
        EthSendTransaction response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getTransactionHash());
        }
    }

    @InvokeOnHeader(value="ETH_SEND_RAW_TRANSACTION")
    void ethSendRawTransaction(Message message) throws IOException {
        String signedTransactionData = message.getHeader("SIGNED_TRANSACTION_DATA", this.configuration::getSignedTransactionData, String.class);
        Request<?, EthSendTransaction> request = this.web3j.ethSendRawTransaction(signedTransactionData);
        this.setRequestId(message, request);
        EthSendTransaction response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getTransactionHash());
        }
    }

    @InvokeOnHeader(value="ETH_CALL")
    void ethCall(Message message) throws IOException {
        String fromAddress = message.getHeader("FROM_ADDRESS", this.configuration::getFromAddress, String.class);
        String toAddress = message.getHeader("TO_ADDRESS", this.configuration::getToAddress, String.class);
        BigInteger nonce = message.getHeader("NONCE", this.configuration::getNonce, BigInteger.class);
        BigInteger gasPrice = message.getHeader("GAS_PRICE", this.configuration::getGasPrice, BigInteger.class);
        BigInteger gasLimit = message.getHeader("GAS_LIMIT", this.configuration::getGasLimit, BigInteger.class);
        BigInteger value = message.getHeader("VALUE", this.configuration::getValue, BigInteger.class);
        String data2 = message.getHeader("DATA", this.configuration::getData, String.class);
        DefaultBlockParameter atBlock = Web3jHelper.toDefaultBlockParameter(message.getHeader("AT_BLOCK", this.configuration::getAtBlock, String.class));
        Transaction transaction = new Transaction(fromAddress, nonce, gasPrice, gasLimit, toAddress, value, data2);
        Request<?, EthCall> request = this.web3j.ethCall(transaction, atBlock);
        this.setRequestId(message, request);
        EthCall response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getValue());
        }
    }

    @InvokeOnHeader(value="ETH_ESTIMATE_GAS")
    void ethEstimateGas(Message message) throws IOException {
        String fromAddress = message.getHeader("FROM_ADDRESS", this.configuration::getFromAddress, String.class);
        String toAddress = message.getHeader("TO_ADDRESS", this.configuration::getToAddress, String.class);
        String data2 = message.getHeader("DATA", this.configuration::getData, String.class);
        Transaction transaction = new Transaction(fromAddress, null, null, null, toAddress, null, data2);
        Request<?, EthEstimateGas> request = this.web3j.ethEstimateGas(transaction);
        this.setRequestId(message, request);
        EthEstimateGas response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getAmountUsed());
        }
    }

    @InvokeOnHeader(value="ETH_GET_BLOCK_BY_HASH")
    void ethGetBlockByHash(Message message) throws IOException {
        Boolean fullTransactionObjects = message.getHeader("FULL_TRANSACTION_OBJECTS", this.configuration::isFullTransactionObjects, Boolean.class);
        String blockHash = message.getHeader("BLOCK_HASH", this.configuration::getBlockHash, String.class);
        Request<?, EthBlock> request = this.web3j.ethGetBlockByHash(blockHash, fullTransactionObjects);
        this.setRequestId(message, request);
        EthBlock response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getBlock());
        }
    }

    @InvokeOnHeader(value="ETH_GET_BLOCK_BY_NUMBER")
    void ethGetBlockByNumber(Message message) throws IOException {
        DefaultBlockParameter atBlock = Web3jHelper.toDefaultBlockParameter(message.getHeader("AT_BLOCK", this.configuration::getAtBlock, String.class));
        Boolean fullTransactionObjects = message.getHeader("FULL_TRANSACTION_OBJECTS", this.configuration::isFullTransactionObjects, Boolean.class);
        Request<?, EthBlock> request = this.web3j.ethGetBlockByNumber(atBlock, fullTransactionObjects);
        this.setRequestId(message, request);
        EthBlock response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getBlock());
        }
    }

    @InvokeOnHeader(value="ETH_GET_TRANSACTION_BY_HASH")
    void ethGetTransactionByHash(Message message) throws IOException {
        String transactionHash = message.getHeader("TRANSACTION_HASH", this.configuration::getTransactionHash, String.class);
        Request<?, EthTransaction> request = this.web3j.ethGetTransactionByHash(transactionHash);
        this.setRequestId(message, request);
        EthTransaction response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getTransaction().isPresent() ? response.getTransaction().get() : null);
        }
    }

    @InvokeOnHeader(value="ETH_GET_TRANSACTION_BY_BLOCK_HASH_AND_INDEX")
    void ethGetTransactionByBlockHashAndIndex(Message message) throws IOException {
        String blockHash = message.getHeader("BLOCK_HASH", this.configuration::getBlockHash, String.class);
        BigInteger transactionIndex = message.getHeader("INDEX", this.configuration::getIndex, BigInteger.class);
        Request<?, EthTransaction> request = this.web3j.ethGetTransactionByBlockHashAndIndex(blockHash, transactionIndex);
        this.setRequestId(message, request);
        EthTransaction response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getTransaction().isPresent() ? response.getTransaction().get() : null);
        }
    }

    @InvokeOnHeader(value="ETH_GET_TRANSACTION_BY_BLOCK_NUMBER_AND_INDEX")
    void ethGetTransactionByBlockNumberAndIndex(Message message) throws IOException {
        DefaultBlockParameter atBlock = Web3jHelper.toDefaultBlockParameter(message.getHeader("AT_BLOCK", this.configuration::getAtBlock, String.class));
        BigInteger transactionIndex = message.getHeader("INDEX", this.configuration::getIndex, BigInteger.class);
        Request<?, EthTransaction> request = this.web3j.ethGetTransactionByBlockNumberAndIndex(atBlock, transactionIndex);
        this.setRequestId(message, request);
        EthTransaction response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getTransaction().isPresent() ? response.getTransaction().get() : null);
        }
    }

    @InvokeOnHeader(value="ETH_GET_UNCLE_BY_BLOCK_HASH_AND_INDEX")
    void ethGetUncleByBlockHashAndIndex(Message message) throws IOException {
        String blockHash = message.getHeader("BLOCK_HASH", this.configuration::getBlockHash, String.class);
        BigInteger uncleIndex = message.getHeader("INDEX", this.configuration::getIndex, BigInteger.class);
        Request<?, EthBlock> request = this.web3j.ethGetUncleByBlockHashAndIndex(blockHash, uncleIndex);
        this.setRequestId(message, request);
        EthBlock response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getBlock());
        }
    }

    @InvokeOnHeader(value="ETH_GET_UNCLE_BY_BLOCK_NUMBER_AND_INDEX")
    void ethGetUncleByBlockNumberAndIndex(Message message) throws IOException {
        DefaultBlockParameter atBlock = Web3jHelper.toDefaultBlockParameter(message.getHeader("AT_BLOCK", this.configuration::getAtBlock, String.class));
        BigInteger uncleIndex = message.getHeader("INDEX", this.configuration::getIndex, BigInteger.class);
        Request<?, EthBlock> request = this.web3j.ethGetUncleByBlockNumberAndIndex(atBlock, uncleIndex);
        this.setRequestId(message, request);
        EthBlock response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getBlock());
        }
    }

    @InvokeOnHeader(value="ETH_GET_TRANSACTION_RECEIPT")
    void ethGetTransactionReceipt(Message message) throws IOException {
        String transactionHash = message.getHeader("TRANSACTION_HASH", this.configuration::getTransactionHash, String.class);
        Request<?, EthGetTransactionReceipt> request = this.web3j.ethGetTransactionReceipt(transactionHash);
        this.setRequestId(message, request);
        EthGetTransactionReceipt response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getTransactionReceipt());
        }
    }

    @InvokeOnHeader(value="ETH_GET_COMPILERS")
    void ethGetCompilers(Message message) throws IOException {
        Request<?, EthGetCompilers> request = this.web3j.ethGetCompilers();
        this.setRequestId(message, request);
        EthGetCompilers response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getCompilers());
        }
    }

    @InvokeOnHeader(value="ETH_COMPILE_LLL")
    void ethCompileLLL(Message message) throws IOException {
        String sourceCode = message.getHeader("SOURCE_CODE", this.configuration::getSourceCode, String.class);
        Request<?, EthCompileLLL> request = this.web3j.ethCompileLLL(sourceCode);
        this.setRequestId(message, request);
        EthCompileLLL response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getCompiledSourceCode());
        }
    }

    @InvokeOnHeader(value="ETH_COMPILE_SOLIDITY")
    void ethCompileSolidity(Message message) throws IOException {
        String sourceCode = message.getHeader("SOURCE_CODE", this.configuration::getSourceCode, String.class);
        Request<?, EthCompileSolidity> request = this.web3j.ethCompileSolidity(sourceCode);
        this.setRequestId(message, request);
        EthCompileSolidity response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getCompiledSolidity());
        }
    }

    @InvokeOnHeader(value="ETH_COMPILE_SERPENT")
    void ethCompileSerpent(Message message) throws IOException {
        String sourceCode = message.getHeader("SOURCE_CODE", this.configuration::getSourceCode, String.class);
        Request<?, EthCompileSerpent> request = this.web3j.ethCompileSerpent(sourceCode);
        this.setRequestId(message, request);
        EthCompileSerpent response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getCompiledSourceCode());
        }
    }

    @InvokeOnHeader(value="ETH_NEW_FILTER")
    void ethNewFilter(Message message) throws IOException {
        DefaultBlockParameter fromBlock = Web3jHelper.toDefaultBlockParameter(message.getHeader("FROM_BLOCK", this.configuration::getFromBlock, String.class));
        DefaultBlockParameter toBlock = Web3jHelper.toDefaultBlockParameter(message.getHeader("TO_BLOCK", this.configuration::getToBlock, String.class));
        List addresses = message.getHeader("ADDRESSES", this.configuration::getAddresses, List.class);
        List topics = message.getHeader("TOPICS", this.configuration::getTopics, List.class);
        EthFilter ethFilter = Web3jEndpoint.buildEthFilter(fromBlock, toBlock, addresses, topics);
        Request<?, org.web3j.protocol.core.methods.response.EthFilter> request = this.web3j.ethNewFilter(ethFilter);
        this.setRequestId(message, request);
        org.web3j.protocol.core.methods.response.EthFilter response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getFilterId());
        }
    }

    @InvokeOnHeader(value="ETH_NEW_BLOCK_FILTER")
    void ethNewBlockFilter(Message message) throws IOException {
        Request<?, org.web3j.protocol.core.methods.response.EthFilter> request = this.web3j.ethNewBlockFilter();
        this.setRequestId(message, request);
        org.web3j.protocol.core.methods.response.EthFilter response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getFilterId());
        }
    }

    @InvokeOnHeader(value="ETH_NEW_PENDING_TRANSACTION_FILTER")
    void ethNewPendingTransactionFilter(Message message) throws IOException {
        Request<?, org.web3j.protocol.core.methods.response.EthFilter> request = this.web3j.ethNewPendingTransactionFilter();
        this.setRequestId(message, request);
        org.web3j.protocol.core.methods.response.EthFilter response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getFilterId());
        }
    }

    @InvokeOnHeader(value="ETH_UNINSTALL_FILTER")
    void ethUninstallFilter(Message message) throws IOException {
        BigInteger filterId = message.getHeader("FILTER_ID", this.configuration::getFilterId, BigInteger.class);
        Request<?, EthUninstallFilter> request = this.web3j.ethUninstallFilter(filterId);
        this.setRequestId(message, request);
        EthUninstallFilter response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.isUninstalled());
        }
    }

    @InvokeOnHeader(value="ETH_GET_FILTER_CHANGES")
    void ethGetFilterChanges(Message message) throws IOException {
        BigInteger filterId = message.getHeader("FILTER_ID", this.configuration::getFilterId, BigInteger.class);
        Request<?, EthLog> request = this.web3j.ethGetFilterChanges(filterId);
        this.setRequestId(message, request);
        EthLog response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getLogs());
        }
    }

    @InvokeOnHeader(value="ETH_GET_FILTER_LOGS")
    void ethGetFilterLogs(Message message) throws IOException {
        BigInteger filterId = message.getHeader("FILTER_ID", this.configuration::getFilterId, BigInteger.class);
        Request<?, EthLog> request = this.web3j.ethGetFilterLogs(filterId);
        this.setRequestId(message, request);
        EthLog response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getLogs());
        }
    }

    @InvokeOnHeader(value="ETH_GET_LOGS")
    void ethGetLogs(Message message) throws IOException {
        DefaultBlockParameter fromBlock = Web3jHelper.toDefaultBlockParameter(message.getHeader("FROM_BLOCK", this.configuration::getFromBlock, String.class));
        DefaultBlockParameter toBlock = Web3jHelper.toDefaultBlockParameter(message.getHeader("TO_BLOCK", this.configuration::getToBlock, String.class));
        List addresses = message.getHeader("ADDRESSES", this.configuration::getAddresses, List.class);
        List topics = message.getHeader("TOPICS", this.configuration::getTopics, List.class);
        EthFilter ethFilter = Web3jEndpoint.buildEthFilter(fromBlock, toBlock, addresses, topics);
        Request<?, EthLog> request = this.web3j.ethGetLogs(ethFilter);
        this.setRequestId(message, request);
        EthLog response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getLogs());
        }
    }

    @InvokeOnHeader(value="ETH_GET_WORK")
    void ethGetWork(Message message) throws IOException {
        Request<?, EthGetWork> request = this.web3j.ethGetWork();
        this.setRequestId(message, request);
        EthGetWork response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getResult());
        }
    }

    @InvokeOnHeader(value="ETH_SUBMIT_WORK")
    void ethSubmitWork(Message message) throws IOException {
        String nonce = message.getHeader("NONCE", this.configuration::getNonce, String.class);
        String headerPowHash = message.getHeader("HEADER_POW_HASH", this.configuration::getHeaderPowHash, String.class);
        String mixDigest = message.getHeader("MIX_DIGEST", this.configuration::getMixDigest, String.class);
        Request<?, EthSubmitWork> request = this.web3j.ethSubmitWork(nonce, headerPowHash, mixDigest);
        this.setRequestId(message, request);
        EthSubmitWork response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.solutionValid());
        }
    }

    @InvokeOnHeader(value="ETH_SUBMIT_HASHRATE")
    void ethSubmitHashrate(Message message) throws IOException {
        String hashrate = message.getHeader("ETH_HASHRATE", this.configuration::getHashrate, String.class);
        String clientId = message.getHeader("CLIENT_ID", this.configuration::getClientId, String.class);
        Request<?, EthSubmitHashrate> request = this.web3j.ethSubmitHashrate(hashrate, clientId);
        this.setRequestId(message, request);
        EthSubmitHashrate response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.submissionSuccessful());
        }
    }

    @InvokeOnHeader(value="DB_PUT_STRING")
    void dbPutString(Message message) throws IOException {
        String databaseName = message.getHeader("DATABASE_NAME", this.configuration::getDatabaseName, String.class);
        String keyName = message.getHeader("KEY_NAME", this.configuration::getKeyName, String.class);
        Request<?, DbPutString> request = this.web3j.dbPutString(databaseName, keyName, message.getBody(String.class));
        this.setRequestId(message, request);
        DbPutString response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.valueStored());
        }
    }

    @InvokeOnHeader(value="DB_GET_STRING")
    void dbGetString(Message message) throws IOException {
        String databaseName = message.getHeader("DATABASE_NAME", this.configuration::getDatabaseName, String.class);
        String keyName = message.getHeader("KEY_NAME", this.configuration::getKeyName, String.class);
        Request<?, DbGetString> request = this.web3j.dbGetString(databaseName, keyName);
        this.setRequestId(message, request);
        DbGetString response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getStoredValue());
        }
    }

    @InvokeOnHeader(value="DB_PUT_HEX")
    void dbPutHex(Message message) throws IOException {
        String databaseName = message.getHeader("DATABASE_NAME", this.configuration::getDatabaseName, String.class);
        String keyName = message.getHeader("KEY_NAME", this.configuration::getKeyName, String.class);
        Request<?, DbPutHex> request = this.web3j.dbPutHex(databaseName, keyName, message.getBody(String.class));
        this.setRequestId(message, request);
        DbPutHex response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.valueStored());
        }
    }

    @InvokeOnHeader(value="DB_GET_HEX")
    void dbGetHex(Message message) throws IOException {
        String databaseName = message.getHeader("DATABASE_NAME", this.configuration::getDatabaseName, String.class);
        String keyName = message.getHeader("KEY_NAME", this.configuration::getKeyName, String.class);
        Request<?, DbGetHex> request = this.web3j.dbGetHex(databaseName, keyName);
        this.setRequestId(message, request);
        DbGetHex response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getStoredValue());
        }
    }

    @InvokeOnHeader(value="SHH_VERSION")
    void shhVersion(Message message) throws IOException {
        Request<?, ShhVersion> request = this.web3j.shhVersion();
        this.setRequestId(message, request);
        ShhVersion response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getVersion());
        }
    }

    @InvokeOnHeader(value="SHH_POST")
    void shhPost(Message message) throws IOException {
        String fromAddress = message.getHeader("FROM_ADDRESS", this.configuration::getFromAddress, String.class);
        String toAddress = message.getHeader("TO_ADDRESS", this.configuration::getToAddress, String.class);
        List topics = message.getHeader("TOPICS", this.configuration::getTopics, List.class);
        String data2 = message.getHeader("DATA", this.configuration::getData, String.class);
        BigInteger priority = message.getHeader("PRIORITY", this.configuration::getPriority, BigInteger.class);
        BigInteger ttl = message.getHeader("TTL", this.configuration::getTtl, BigInteger.class);
        ShhPost shhPost = new ShhPost(fromAddress, toAddress, topics, data2, priority, ttl);
        Request<?, org.web3j.protocol.core.methods.response.ShhPost> request = this.web3j.shhPost(shhPost);
        this.setRequestId(message, request);
        org.web3j.protocol.core.methods.response.ShhPost response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.messageSent());
        }
    }

    @InvokeOnHeader(value="SHH_NEW_IDENTITY")
    void shhNewIdentity(Message message) throws IOException {
        Request<?, ShhNewIdentity> request = this.web3j.shhNewIdentity();
        this.setRequestId(message, request);
        ShhNewIdentity response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getAddress());
        }
    }

    @InvokeOnHeader(value="SHH_HAS_IDENTITY")
    void shhHasIdentity(Message message) throws IOException {
        String identityAddress = message.getHeader("ADDRESS", this.configuration::getAddress, String.class);
        Request<?, ShhHasIdentity> request = this.web3j.shhHasIdentity(identityAddress);
        this.setRequestId(message, request);
        ShhHasIdentity response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.hasPrivateKeyForIdentity());
        }
    }

    @InvokeOnHeader(value="SHH_NEW_GROUP")
    void shhNewGroup(Message message) throws IOException {
        Request<?, ShhNewGroup> request = this.web3j.shhNewGroup();
        this.setRequestId(message, request);
        ShhNewGroup response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getAddress());
        }
    }

    @InvokeOnHeader(value="SHH_ADD_TO_GROUP")
    void shhAddToGroup(Message message) throws IOException {
        String identityAddress = message.getHeader("ADDRESS", this.configuration::getAddress, String.class);
        Request<?, ShhAddToGroup> request = this.web3j.shhAddToGroup(identityAddress);
        this.setRequestId(message, request);
        ShhAddToGroup response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.addedToGroup());
        }
    }

    @InvokeOnHeader(value="SHH_NEW_FILTER")
    void shhNewFilter(Message message) throws IOException {
        String data2 = message.getHeader("DATA", this.configuration::getData, String.class);
        List topics = message.getHeader("TOPICS", this.configuration::getTopics, List.class);
        ShhFilter shhFilter = Web3jEndpoint.buildShhFilter(data2, topics);
        Request<?, ShhNewFilter> request = this.web3j.shhNewFilter(shhFilter);
        this.setRequestId(message, request);
        ShhNewFilter response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getFilterId());
        }
    }

    @InvokeOnHeader(value="SHH_UNINSTALL_FILTER")
    void shhUninstallFilter(Message message) throws IOException {
        BigInteger filterId = message.getHeader("FILTER_ID", this.configuration::getFilterId, BigInteger.class);
        Request<?, ShhUninstallFilter> request = this.web3j.shhUninstallFilter(filterId);
        this.setRequestId(message, request);
        ShhUninstallFilter response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.isUninstalled());
        }
    }

    @InvokeOnHeader(value="SHH_GET_FILTER_CHANGES")
    void shhGetFilterChanges(Message message) throws IOException {
        BigInteger filterId = message.getHeader("FILTER_ID", this.configuration::getFilterId, BigInteger.class);
        Request<?, ShhMessages> request = this.web3j.shhGetFilterChanges(filterId);
        this.setRequestId(message, request);
        ShhMessages response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getMessages());
        }
    }

    @InvokeOnHeader(value="SHH_GET_MESSAGES")
    void shhGetMessages(Message message) throws IOException {
        BigInteger filterId = message.getHeader("FILTER_ID", this.configuration::getFilterId, BigInteger.class);
        Request<?, ShhMessages> request = this.web3j.shhGetMessages(filterId);
        this.setRequestId(message, request);
        ShhMessages response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getMessages());
        }
    }

    @InvokeOnHeader(value="QUORUM_NODE_INFO")
    void quorumNodeInfo(Message message) throws IOException {
        if (this.quorum == null) {
            this.setQuorumEndpointError(message);
            return;
        }
        Request<?, AdminNodeInfo> request = this.quorum.adminNodeInfo();
        this.setRequestId(message, request);
        AdminNodeInfo response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getResult());
        }
    }

    @InvokeOnHeader(value="QUORUM_GET_PRIVATE_PAYLOAD")
    void quorumGetPrivatePayload(Message message) throws IOException {
        if (this.quorum == null) {
            this.setQuorumEndpointError(message);
            return;
        }
        Request<?, PrivatePayload> request = this.quorum.quorumGetPrivatePayload(message.getBody(String.class));
        this.setRequestId(message, request);
        PrivatePayload response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getPrivatePayload());
        }
    }

    @InvokeOnHeader(value="QUORUM_ETH_SEND_TRANSACTION")
    void quorumEthSendTransaction(Message message) throws IOException {
        if (this.quorum == null) {
            this.setQuorumEndpointError(message);
            return;
        }
        String fromAddress = message.getHeader("FROM_ADDRESS", this.configuration::getFromAddress, String.class);
        String toAddress = message.getHeader("TO_ADDRESS", this.configuration::getToAddress, String.class);
        BigInteger nonce = message.getHeader("NONCE", this.configuration::getNonce, BigInteger.class);
        BigInteger gasLimit = message.getHeader("GAS_LIMIT", this.configuration::getGasLimit, BigInteger.class);
        BigInteger value = message.getHeader("VALUE", this.configuration::getValue, BigInteger.class);
        String data2 = message.getHeader("DATA", this.configuration::getData, String.class);
        List privateFor = message.getHeader("PRIVATE_FOR", this.configuration::getPrivateFor, List.class);
        String privateFrom = message.getHeader("PRIVATE_FROM", String.class);
        PrivateTransaction transaction = new PrivateTransaction(fromAddress, nonce, gasLimit, toAddress, value, data2, privateFrom, privateFor);
        Request<?, EthSendTransaction> request = this.quorum.ethSendTransaction(transaction);
        this.setRequestId(message, request);
        EthSendTransaction response = request.send();
        boolean hasError = this.checkForError(message, response);
        if (!hasError) {
            message.setBody(response.getTransactionHash());
        }
    }

    private void setRequestId(Message message, Request<?, ?> request) {
        Long id = message.getHeader("ID", Long.class);
        LOG.debug("setRequestId {}", (Object)id);
        if (id != null) {
            request.setId(id);
        }
    }

    private boolean checkForError(Message message, Response<?> response) {
        if (response.hasError()) {
            int code = response.getError().getCode();
            String data2 = response.getError().getData();
            String messages = response.getError().getMessage();
            message.setHeader("ERROR_CODE", code);
            message.setHeader("ERROR_DATA", data2);
            message.setHeader("ERROR_MESSAGE", messages);
            message.getExchange().setException(new CamelExchangeException("Web3j failed. Error code: " + code + " data: " + data2 + " messages: " + messages, message.getExchange()));
            return true;
        }
        return false;
    }

    private void setQuorumEndpointError(Message message) {
        message.getExchange().setException(new CamelExchangeException("This is not a Quorum endpoint. Create one by specifying quorumAPI=true", message.getExchange()));
    }
}

