/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;

public final class InputStreamCache
extends ByteArrayInputStream
implements StreamCache {
    public InputStreamCache(byte[] data2) {
        super(data2);
    }

    public InputStreamCache(byte[] data2, int count) {
        super(data2);
        this.count = count;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        os.write(this.buf, this.pos, this.count - this.pos);
    }

    @Override
    public StreamCache copy(Exchange exchange) {
        return new InputStreamCache(this.buf, this.count);
    }

    @Override
    public boolean inMemory() {
        return true;
    }

    @Override
    public long length() {
        return this.count;
    }

    @Override
    public long position() {
        return this.available() - this.count;
    }
}

