/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.resume;

import java.io.File;
import java.nio.ByteBuffer;
import org.apache.camel.util.ObjectHelper;

@FunctionalInterface
public interface Serializable {
    public static final int TYPE_INTEGER = 0;
    public static final int TYPE_LONG = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_FILE = 3;
    public static final int BYTES = 1024;

    default public ByteBuffer serialize(Object obj) {
        ObjectHelper.notNull(obj, "Cannot perform serialization on a null object");
        if (obj instanceof Long) {
            Long value = (Long)obj;
            ByteBuffer buffer = ByteBuffer.allocate(12);
            buffer.putInt(1);
            long data2 = value;
            buffer.putLong(data2);
            return buffer;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            byte[] data3 = str.getBytes();
            ByteBuffer buffer = ByteBuffer.allocate(4 + data3.length);
            buffer.putInt(2);
            buffer.put(data3);
            return buffer;
        }
        if (obj instanceof File) {
            File file = (File)obj;
            byte[] data4 = file.getPath().getBytes();
            ByteBuffer buffer = ByteBuffer.allocate(4 + data4.length);
            buffer.putInt(3);
            buffer.put(data4);
            return buffer;
        }
        return null;
    }

    public ByteBuffer serialize();
}

