/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.cache;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SimpleSoftCache<K, V>
implements Map<K, V> {
    private final Map<K, SoftReference<V>> delegate;

    public SimpleSoftCache(Map<K, SoftReference<V>> delegate) {
        this.delegate = delegate;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<K, SoftReference<V>> entry : this.delegate.entrySet()) {
            SoftReference<V> ref = entry.getValue();
            V refVal = ref.get();
            if (refVal == null) {
                this.delegate.remove(entry.getKey(), ref);
                continue;
            }
            if (!Objects.equals(value, refVal)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        SoftReference<V> ref = this.delegate.get(key);
        if (ref == null) {
            return null;
        }
        V v = ref.get();
        if (v == null) {
            this.delegate.remove(key, ref);
        }
        return v;
    }

    @Override
    public V put(K key, V value) {
        SoftReference<V> prev = this.delegate.put(key, new SoftReference<V>(value));
        return prev == null ? null : (V)prev.get();
    }

    @Override
    public V remove(Object key) {
        SoftReference<V> prev = this.delegate.remove(key);
        return prev == null ? null : (V)prev.get();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.delegate.put(e.getKey(), new SoftReference<V>(e.getValue()));
        }
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values().stream().map(Reference::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> result2 = new HashSet<Map.Entry<K, V>>(this.delegate.size());
        for (Map.Entry<K, SoftReference<V>> entry : this.delegate.entrySet()) {
            SoftReference<V> ref = entry.getValue();
            V v = ref.get();
            if (v == null) {
                this.delegate.remove(entry.getKey(), ref);
                continue;
            }
            result2.add(Map.entry(entry.getKey(), v));
        }
        return result2;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.delegate.forEach((k, ref) -> {
            Object v = ref.get();
            if (v == null) {
                this.delegate.remove(k, ref);
            } else {
                action.accept((K)k, (V)v);
            }
        });
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        for (Map.Entry<K, V> e : this.entrySet()) {
            this.replace(e.getKey(), e.getValue(), function.apply(e.getKey(), e.getValue()));
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V prev;
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        while (true) {
            SoftReference<V> ref = this.delegate.get(key);
            prev = null;
            if (ref == null) {
                SoftReference<V> prevRef = this.delegate.putIfAbsent(key, new SoftReference<V>(value));
                if (prevRef == null) break;
                V v = prevRef.get();
                prev = v;
                if (v != null) break;
                this.delegate.remove(key, prevRef);
                continue;
            }
            prev = ref.get();
            if (prev != null || this.delegate.replace(key, ref, new SoftReference<V>(value))) break;
        }
        return prev;
    }

    @Override
    public boolean remove(Object key, Object value) {
        V v;
        SoftReference<V> ref;
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        while ((ref = this.delegate.get(key)) != null && ((v = ref.get()) == null || Objects.equals(v, value))) {
            if (!this.delegate.remove(key, ref)) continue;
            return v != null;
        }
        return false;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        SoftReference<V> ref;
        if (key == null || oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        while ((ref = this.delegate.get(key)) != null) {
            V v = ref.get();
            if (v == null) {
                if (this.delegate.remove(key, ref)) break;
                continue;
            }
            if (!Objects.equals(v, oldValue)) break;
            if (!this.delegate.replace(key, ref, new SoftReference<V>(newValue))) continue;
            return true;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        SoftReference<V> ref;
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        while ((ref = this.delegate.get(key)) != null) {
            V v = ref.get();
            if (v == null ? !this.delegate.remove(key, ref) : !this.delegate.replace(key, ref, new SoftReference<V>(value))) continue;
            return v;
        }
        return null;
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V v;
        if (key == null || mappingFunction == null) {
            throw new NullPointerException();
        }
        while (true) {
            SoftReference<V> ref;
            if ((ref = this.delegate.get(key)) == null) {
                V newValue = mappingFunction.apply(key);
                if (newValue != null && this.delegate.putIfAbsent(key, new SoftReference<V>(newValue)) != null) continue;
                return newValue;
            }
            v = ref.get();
            if (v != null) break;
            this.delegate.remove(key, ref);
        }
        return v;
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        SoftReference<V> ref;
        if (key == null || remappingFunction == null) {
            throw new NullPointerException();
        }
        while ((ref = this.delegate.get(key)) != null) {
            V v = ref.get();
            if (v == null) {
                if (!this.delegate.remove(key, ref)) continue;
                return null;
            }
            V newValue = remappingFunction.apply(key, v);
            if (newValue == null ? !this.delegate.remove(key, ref) : !this.delegate.replace(key, ref, new SoftReference<V>(newValue))) continue;
            return newValue;
        }
        return null;
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        SoftReference<V> ref;
        Object oldValue;
        V newValue;
        if (key == null || remappingFunction == null) {
            throw new NullPointerException();
        }
        while ((newValue = remappingFunction.apply(key, oldValue = (ref = this.delegate.get(key)) == null ? null : (Object)ref.get())) == null ? ref != null && !this.delegate.remove(key, ref) : (ref == null ? this.delegate.putIfAbsent(key, new SoftReference<V>(newValue)) != null : !this.delegate.replace(key, ref, new SoftReference<V>(newValue)))) {
        }
        return newValue;
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        SoftReference<V> ref;
        V newValue;
        if (key == null || value == null || remappingFunction == null) {
            throw new NullPointerException();
        }
        do {
            Object oldValue = (ref = this.delegate.get(key)) == null ? null : (Object)ref.get();
            V v = newValue = oldValue == null ? value : remappingFunction.apply(oldValue, value);
        } while (newValue == null ? !this.delegate.remove(key, ref) : (ref == null ? this.delegate.putIfAbsent(key, new SoftReference<V>(newValue)) != null : !this.delegate.replace(key, ref, new SoftReference<V>(newValue))));
        return newValue;
    }

    Map<K, SoftReference<V>> getInnerCache() {
        return this.delegate;
    }
}

