/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.resume;

import java.nio.ByteBuffer;
import org.apache.camel.resume.Cacheable;
import org.apache.camel.resume.Deserializable;
import org.apache.camel.resume.Offset;
import org.apache.camel.resume.OffsetKey;
import org.apache.camel.resume.ResumeAction;
import org.apache.camel.resume.ResumeActionAware;
import org.apache.camel.resume.cache.ResumeCache;
import org.apache.camel.spi.annotations.JdkService;

@JdkService(value="adapter-factory")
public class ResumeActionAwareAdapter
implements ResumeActionAware,
Cacheable,
Deserializable {
    private ResumeCache<Object> cache;
    private ResumeAction resumeAction;

    @Override
    public void setResumeAction(ResumeAction resumeAction) {
        this.resumeAction = resumeAction;
    }

    @Override
    public void resume() {
        this.cache.forEach(this.resumeAction::evalEntry);
    }

    private boolean add(Object key, Object offset) {
        this.cache.add(key, offset);
        return true;
    }

    @Override
    public boolean add(OffsetKey<?> key, Offset<?> offset) {
        return this.add(key.getValue(), offset.getValue());
    }

    @Override
    public void setCache(ResumeCache<?> cache2) {
        this.cache = cache2;
    }

    @Override
    public ResumeCache<?> getCache() {
        return this.cache;
    }

    @Override
    public boolean deserialize(ByteBuffer keyBuffer, ByteBuffer valueBuffer) {
        Object key = this.deserializeKey(keyBuffer);
        Object value = this.deserializeValue(valueBuffer);
        return this.add(key, value);
    }

    protected ResumeAction getResumeAction() {
        return this.resumeAction;
    }
}

