/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.startup;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.StartupStep;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.support.startup.DefaultStartupStep;

public class DefaultStartupStepRecorder
extends ServiceSupport
implements StartupStepRecorder {
    private static final StartupStep DISABLED_STEP = new StartupStep(){

        @Override
        public String getType() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public int getId() {
            return 0;
        }

        @Override
        public int getParentId() {
            return 0;
        }

        @Override
        public int getLevel() {
            return 0;
        }

        @Override
        public long getBeginTime() {
            return 0L;
        }

        @Override
        public long getDuration() {
            return 0L;
        }

        @Override
        public void endStep() {
        }
    };
    private final AtomicInteger stepCounter = new AtomicInteger();
    private final Deque<Integer> currentSteps = new ArrayDeque<Integer>();
    private boolean enabled;
    private int maxDepth = -1;
    private long startupRecorderDuration;
    private boolean recording;
    private String recordingDir;
    private String recordingProfile = "default";

    public DefaultStartupStepRecorder() {
        this.currentSteps.offerFirst(0);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public long getStartupRecorderDuration() {
        return this.startupRecorderDuration;
    }

    @Override
    public void setStartupRecorderDuration(long startupRecorderDuration) {
        this.startupRecorderDuration = startupRecorderDuration;
    }

    @Override
    public int getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    @Override
    public boolean isRecording() {
        return this.recording;
    }

    @Override
    public void setRecording(boolean recording) {
        this.recording = recording;
    }

    @Override
    public String getRecordingDir() {
        return this.recordingDir;
    }

    @Override
    public void setRecordingDir(String recordingDir) {
        this.recordingDir = recordingDir;
    }

    @Override
    public String getRecordingProfile() {
        return this.recordingProfile;
    }

    @Override
    public void setRecordingProfile(String recordingProfile) {
        this.recordingProfile = recordingProfile;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    public void doStop() throws Exception {
        this.enabled = false;
        this.currentSteps.clear();
    }

    @Override
    public StartupStep beginStep(Class<?> type2, String name, String description2) {
        if (this.enabled) {
            int level = this.currentSteps.size() - 1;
            if (this.maxDepth != -1 && level >= this.maxDepth) {
                return DISABLED_STEP;
            }
            int id = this.stepCounter.incrementAndGet();
            Integer parent = this.currentSteps.peekFirst();
            int pid = parent != null ? parent : 0;
            StartupStep step = this.createStartupStep(type2.getSimpleName(), name, description2, id, pid, level);
            this.onBeginStep(step);
            this.currentSteps.offerFirst(id);
            return step;
        }
        return DISABLED_STEP;
    }

    @Override
    public void endStep(StartupStep step) {
        if (step != DISABLED_STEP) {
            this.currentSteps.pollFirst();
            step.endStep();
            this.onEndStep(step);
        }
    }

    public StartupStep createStartupStep(String type2, String name, String description2, int id, int parentId, int level) {
        return new DefaultStartupStep(type2, name, description2, id, parentId, level, System.currentTimeMillis());
    }

    protected void onBeginStep(StartupStep step) {
    }

    protected void onEndStep(StartupStep step) {
    }
}

