/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.util.FileUtil;
import org.apache.camel.util.OrderedLocationProperties;
import org.apache.camel.util.StringHelper;

public final class LocationHelper {
    private LocationHelper() {
    }

    public static String locationSummary(OrderedLocationProperties properties2, String key) {
        Object loc = properties2.getLocation(key);
        if (loc == null) {
            loc = "";
        }
        if (((String)loc).contains(":")) {
            loc = StringHelper.after((String)loc, ":");
        }
        if (((String)(loc = FileUtil.stripPath((String)loc))).length() > 28) {
            int pos = ((String)loc).length() - 28;
            loc = ((String)loc).substring(pos);
        }
        if ("initial".equals(loc) || "override".equals(loc)) {
            loc = "camel-main";
        } else if ("SYS".equals(loc)) {
            loc = "JVM System Property";
        } else if ("ENV".equals(loc)) {
            loc = "OS Environment Variable";
        } else if ("arguments".equals(loc) || "CLI".equals(loc)) {
            loc = "Command Line";
        }
        loc = "[" + (String)loc + "]";
        loc = String.format("%-30s", loc);
        return loc;
    }
}

