/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ObjectHelper {
    private ObjectHelper() {
    }

    public static boolean equal(Object a, Object b) {
        return ObjectHelper.equal(a, b, false);
    }

    public static boolean equalIgnoreCase(Object a, Object b) {
        return ObjectHelper.equal(a, b, true);
    }

    public static boolean equal(Object a, Object b, boolean ignoreCase) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (ignoreCase && a instanceof String) {
            String strA = (String)a;
            if (b instanceof String) {
                String strB = (String)b;
                return strA.equalsIgnoreCase(strB);
            }
        }
        if (a.getClass().isArray() && b.getClass().isArray()) {
            return Objects.deepEquals(a, b);
        }
        return a.equals(b);
    }

    public static boolean equalByteArray(byte[] a, byte[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean isEqualToAny(Object object, Object ... values2) {
        for (Object value : values2) {
            if (!ObjectHelper.equal(object, value)) continue;
            return true;
        }
        return false;
    }

    public static Boolean toBoolean(Object value) {
        String str;
        byte[] bytes;
        String str2;
        if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            return booleanValue;
        }
        if (value instanceof byte[] && ObjectHelper.isBoolean(str2 = new String(bytes = (byte[])value))) {
            return Boolean.valueOf(str2);
        }
        if (value instanceof String && ObjectHelper.isBoolean(str = (String)value)) {
            return Boolean.valueOf(str);
        }
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            return integer > 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public static <T> T notNull(T value, String name) {
        if (value == null) {
            throw new IllegalArgumentException(name + " must be specified");
        }
        return value;
    }

    public static String notNullOrEmpty(String value, String name) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(name + " must be specified and non-empty");
        }
        return value;
    }

    public static <T> T notNull(T value, String name, Object on) {
        if (on == null) {
            ObjectHelper.notNull(value, name);
        } else if (value == null) {
            throw new IllegalArgumentException(name + " must be specified on: " + String.valueOf(on));
        }
        return value;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.isBlank();
    }

    public static boolean isEmpty(Collection<?> value) {
        return value == null || value.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> value) {
        return value == null || value.isEmpty();
    }

    public static <T> boolean isEmpty(T value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            String str = (String)value;
            return ObjectHelper.isEmpty(str);
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return ObjectHelper.isEmpty(collection);
        }
        if (value instanceof Map) {
            Map valueMap = (Map)value;
            return ObjectHelper.isEmpty(valueMap);
        }
        return false;
    }

    public static <T> boolean isNotEmpty(T value) {
        return !ObjectHelper.isEmpty(value);
    }

    public static boolean isNotEmpty(String value) {
        return !ObjectHelper.isEmpty(value);
    }

    public static boolean isNotEmpty(Collection<?> value) {
        return !ObjectHelper.isEmpty(value);
    }

    public static boolean isNotEmpty(Map<?, ?> value) {
        return !ObjectHelper.isEmpty(value);
    }

    public static Optional<Object> firstNotNull(Object ... values2) {
        for (Object value : values2) {
            if (value == null) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static <T> T supplyIfEmpty(T value, Supplier<T> supplier) {
        ObjectHelper.notNull(supplier, "Supplier");
        if (ObjectHelper.isNotEmpty(value)) {
            return value;
        }
        return supplier.get();
    }

    public static <T> void ifNotEmpty(T value, Consumer<T> consumer) {
        if (ObjectHelper.isNotEmpty(value)) {
            consumer.accept(value);
        }
    }

    public static boolean matches(List<?> list) {
        if (!list.isEmpty()) {
            Object value = list.get(0);
            if (value instanceof Boolean) {
                Boolean booleanValue = (Boolean)value;
                return booleanValue;
            }
            return true;
        }
        return false;
    }

    public static String getSystemProperty(String name, String defaultValue) {
        try {
            return System.getProperty(name, defaultValue);
        }
        catch (Exception e) {
            ObjectHelper.logger().debug("Caught security exception accessing system property: {}. Will use default value: {}", new Object[]{name, defaultValue, e});
            return defaultValue;
        }
    }

    public static boolean getSystemProperty(String name, Boolean defaultValue) {
        String result2 = ObjectHelper.getSystemProperty(name, defaultValue.toString());
        return Boolean.parseBoolean(result2);
    }

    public static String name(Class<?> type2) {
        return type2 != null ? type2.getName() : null;
    }

    public static String className(Object value) {
        return ObjectHelper.name(value != null ? value.getClass() : null);
    }

    public static String classCanonicalName(Object value) {
        if (value != null) {
            return value.getClass().getCanonicalName();
        }
        return null;
    }

    public static Class<?> loadClass(String name) {
        return ObjectHelper.loadClass(name, ObjectHelper.class.getClassLoader());
    }

    public static Class<?> loadClass(String name, ClassLoader loader) {
        return ObjectHelper.loadClass(name, loader, false);
    }

    public static Class<?> loadClass(String name, ClassLoader loader, boolean needToWarn) {
        if (ObjectHelper.isEmpty(name = StringHelper.normalizeClassName(name))) {
            return null;
        }
        boolean array = false;
        Class<?> clazz = ObjectHelper.loadSimpleType(name);
        if (clazz == null && name.endsWith("[]")) {
            name = name.substring(0, name.length() - 2);
            array = true;
        }
        if (clazz == null) {
            clazz = ObjectHelper.doLoadClass(name, Thread.currentThread().getContextClassLoader());
        }
        if (clazz == null) {
            clazz = ObjectHelper.doLoadClass(name, loader);
        }
        if (clazz == null) {
            clazz = ObjectHelper.doLoadClass(name, ObjectHelper.class.getClassLoader());
        }
        if (clazz != null && array) {
            Object arr = Array.newInstance(clazz, 0);
            clazz = arr.getClass();
        }
        if (clazz == null) {
            if (needToWarn) {
                ObjectHelper.logger().warn("Cannot find class: {}", (Object)name);
            } else {
                ObjectHelper.logger().debug("Cannot find class: {}", (Object)name);
            }
        }
        return clazz;
    }

    public static Class<?> loadSimpleType(String name) {
        if ("java.lang.byte[]".equals(name) || "byte[]".equals(name)) {
            return byte[].class;
        }
        if ("java.lang.Byte[]".equals(name) || "Byte[]".equals(name)) {
            return Byte[].class;
        }
        if ("java.lang.Object[]".equals(name) || "Object[]".equals(name)) {
            return Object[].class;
        }
        if ("java.lang.String[]".equals(name) || "String[]".equals(name)) {
            return String[].class;
        }
        if ("java.lang.String".equals(name) || "String".equals(name)) {
            return String.class;
        }
        if ("java.lang.Boolean".equals(name) || "Boolean".equals(name)) {
            return Boolean.class;
        }
        if ("boolean".equals(name)) {
            return Boolean.TYPE;
        }
        if ("java.lang.Integer".equals(name) || "Integer".equals(name)) {
            return Integer.class;
        }
        if ("int".equals(name)) {
            return Integer.TYPE;
        }
        if ("java.lang.Long".equals(name) || "Long".equals(name)) {
            return Long.class;
        }
        if ("long".equals(name)) {
            return Long.TYPE;
        }
        if ("java.lang.Short".equals(name) || "Short".equals(name)) {
            return Short.class;
        }
        if ("short".equals(name)) {
            return Short.TYPE;
        }
        if ("java.lang.Byte".equals(name) || "Byte".equals(name)) {
            return Byte.class;
        }
        if ("byte".equals(name)) {
            return Byte.TYPE;
        }
        if ("java.lang.Float".equals(name) || "Float".equals(name)) {
            return Float.class;
        }
        if ("float".equals(name)) {
            return Float.TYPE;
        }
        if ("java.lang.Double".equals(name) || "Double".equals(name)) {
            return Double.class;
        }
        if ("double".equals(name)) {
            return Double.TYPE;
        }
        if ("java.lang.Character".equals(name) || "Character".equals(name)) {
            return Character.class;
        }
        if ("char".equals(name)) {
            return Character.TYPE;
        }
        return null;
    }

    private static Class<?> doLoadClass(String name, ClassLoader loader) {
        StringHelper.notEmpty(name, "name");
        if (loader == null) {
            return null;
        }
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            if (ObjectHelper.logger().isTraceEnabled()) {
                ObjectHelper.logger().trace("Cannot load class: {} using classloader: {}", new Object[]{name, loader, e});
            }
            return null;
        }
    }

    public static InputStream loadResourceAsStream(String name) {
        return ObjectHelper.loadResourceAsStream(name, null);
    }

    public static InputStream loadResourceAsStream(String name, ClassLoader loader) {
        try {
            URL res = ObjectHelper.loadResourceAsURL(name, loader);
            return res != null ? res.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static URL loadResourceAsURL(String name) {
        return ObjectHelper.loadResourceAsURL(name, null);
    }

    public static URL loadResourceAsURL(String name, ClassLoader loader) {
        URL url;
        String resolvedName = ObjectHelper.resolveUriPath(name);
        if (loader != null && (url = loader.getResource(resolvedName)) != null) {
            return url;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl != null) {
            url = tccl.getResource(resolvedName);
            if (url != null) {
                return url;
            }
            try {
                Class<?> clazz = tccl.loadClass("org.apache.camel.impl.DefaultCamelContext");
                url = clazz.getClassLoader().getResource(resolvedName);
                if (url != null) {
                    return url;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if ((url = ObjectHelper.class.getClassLoader().getResource(resolvedName)) != null) {
            return url;
        }
        url = ObjectHelper.class.getResource(resolvedName);
        return url;
    }

    public static Enumeration<URL> loadResourcesAsURL(String uri) {
        return ObjectHelper.loadResourcesAsURL(uri, null);
    }

    public static Enumeration<URL> loadResourcesAsURL(String uri, ClassLoader loader) {
        ClassLoader tccl;
        Enumeration<URL> res = null;
        if (loader != null) {
            try {
                res = loader.getResources(uri);
                if (res != null) {
                    return res;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((tccl = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                res = tccl.getResources(uri);
                if (res != null) {
                    return res;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Class<?> clazz = tccl.loadClass("org.apache.camel.impl.DefaultCamelContext");
                res = clazz.getClassLoader().getResources(uri);
                if (res != null) {
                    return res;
                }
            }
            catch (IOException | ClassNotFoundException exception) {
                // empty catch block
            }
        }
        try {
            res = ObjectHelper.class.getClassLoader().getResources(uri);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }

    private static String resolveUriPath(String name) {
        return FileUtil.compactPath(name, '/');
    }

    public static boolean isOverridingMethod(Method source2, Method target) {
        return ObjectHelper.isOverridingMethod(source2, target, true);
    }

    public static boolean isOverridingMethod(Method source2, Method target, boolean exact) {
        return ObjectHelper.isOverridingMethod(target.getDeclaringClass(), source2, target, exact);
    }

    public static boolean isOverridingMethod(Class<?> inheritingClass, Method source2, Method target, boolean exact) {
        if (source2.equals(target)) {
            return true;
        }
        if (target.getDeclaringClass().isAssignableFrom(source2.getDeclaringClass())) {
            return false;
        }
        if (!source2.getDeclaringClass().isAssignableFrom(inheritingClass) || !target.getDeclaringClass().isAssignableFrom(inheritingClass)) {
            return false;
        }
        if (!source2.getName().equals(target.getName())) {
            return false;
        }
        if (exact) {
            if (!source2.getReturnType().equals(target.getReturnType())) {
                return false;
            }
        } else if (!source2.getReturnType().isAssignableFrom(target.getReturnType())) {
            boolean b1 = source2.isBridge();
            boolean b2 = target.isBridge();
            if (!b1 && !b2) {
                return false;
            }
        }
        if (source2.getParameterCount() != target.getParameterCount()) {
            return false;
        }
        Class<?>[] sourceTypes = source2.getParameterTypes();
        Class<?>[] targetTypes = target.getParameterTypes();
        for (int i = 0; i < source2.getParameterCount(); ++i) {
            if (exact) {
                if (sourceTypes[i].equals(targetTypes[i])) continue;
                return false;
            }
            if (sourceTypes[i].isAssignableFrom(targetTypes[i])) continue;
            boolean b1 = source2.isBridge();
            boolean b2 = target.isBridge();
            if (b1 || b2) continue;
            return false;
        }
        return true;
    }

    public static List<Method> findMethodsWithAnnotation(Class<?> type2, Class<? extends Annotation> annotationType) {
        return ObjectHelper.findMethodsWithAnnotation(type2, annotationType, false);
    }

    public static List<Method> findMethodsWithAnnotation(Class<?> type2, Class<? extends Annotation> annotationType, boolean checkMetaAnnotations) {
        ArrayList<Method> answer = new ArrayList<Method>();
        do {
            Method[] methods2;
            for (Method method : methods2 = type2.getDeclaredMethods()) {
                if (!ObjectHelper.hasAnnotation(method, annotationType, checkMetaAnnotations)) continue;
                answer.add(method);
            }
        } while ((type2 = type2.getSuperclass()) != null);
        return answer;
    }

    public static boolean hasAnnotation(AnnotatedElement elem, Class<? extends Annotation> annotationType, boolean checkMetaAnnotations) {
        if (elem.isAnnotationPresent(annotationType)) {
            return true;
        }
        if (checkMetaAnnotations) {
            for (Annotation a : elem.getAnnotations()) {
                for (Annotation meta : a.annotationType().getAnnotations()) {
                    if (!meta.annotationType().getName().equals(annotationType.getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String asString(Object[] objects) {
        if (objects == null) {
            return "null";
        }
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("{");
        int counter = 0;
        for (Object object : objects) {
            if (counter++ > 0) {
                buffer.append(", ");
            }
            String text = object == null ? "null" : object.toString();
            buffer.append(text);
        }
        buffer.append("}");
        return buffer.toString();
    }

    public static boolean isAssignableFrom(Class<?> a, Class<?> b) {
        a = ObjectHelper.convertPrimitiveTypeToWrapperType(a);
        b = ObjectHelper.convertPrimitiveTypeToWrapperType(b);
        return a.isAssignableFrom(b);
    }

    public static boolean isPrimitiveArrayType(Class<?> clazz) {
        if (clazz != null && clazz.isArray()) {
            return clazz.getComponentType().isPrimitive();
        }
        return false;
    }

    public static boolean isSubclass(Class<?> clazz, Class<?> subClass) {
        if (clazz == subClass) {
            return true;
        }
        if (clazz == null || subClass == null) {
            return false;
        }
        for (Class<?> aClass = clazz; aClass != null; aClass = aClass.getSuperclass()) {
            Class<?>[] interfaces;
            if (aClass == subClass) {
                return true;
            }
            if (!subClass.isInterface()) continue;
            for (Class<?> anInterface : interfaces = aClass.getInterfaces()) {
                if (!ObjectHelper.isSubclass(anInterface, subClass)) continue;
                return true;
            }
        }
        return false;
    }

    public static int arrayLength(Object[] pojo) {
        return pojo.length;
    }

    public static boolean isNumericType(Class<?> type2) {
        if (type2 == Integer.TYPE || type2 == Integer.class) {
            return true;
        }
        if (type2 == Long.TYPE || type2 == Long.class) {
            return true;
        }
        if (type2 == Double.TYPE || type2 == Double.class) {
            return true;
        }
        if (type2 == Float.TYPE || type2 == Float.class) {
            return true;
        }
        if (type2 == Short.TYPE || type2 == Short.class) {
            return true;
        }
        return type2 == Byte.TYPE || type2 == Byte.class;
    }

    public static Class<?> convertPrimitiveTypeToWrapperType(Class<?> type2) {
        Class<Object> rc = type2;
        if (type2.isPrimitive()) {
            if (type2 == Integer.TYPE) {
                rc = Integer.class;
            } else if (type2 == Long.TYPE) {
                rc = Long.class;
            } else if (type2 == Double.TYPE) {
                rc = Double.class;
            } else if (type2 == Float.TYPE) {
                rc = Float.class;
            } else if (type2 == Short.TYPE) {
                rc = Short.class;
            } else if (type2 == Byte.TYPE) {
                rc = Byte.class;
            } else if (type2 == Boolean.TYPE) {
                rc = Boolean.class;
            } else if (type2 == Character.TYPE) {
                rc = Character.class;
            }
        }
        return rc;
    }

    public static Class<?> convertWrapperTypeToPrimitiveType(Class<?> type2) {
        Class<Object> rc = type2;
        if (type2 == Integer.class) {
            rc = Integer.TYPE;
        } else if (type2 == Long.class) {
            rc = Long.TYPE;
        } else if (type2 == Double.class) {
            rc = Double.TYPE;
        } else if (type2 == Float.class) {
            rc = Float.TYPE;
        } else if (type2 == Short.class) {
            rc = Short.TYPE;
        } else if (type2 == Byte.class) {
            rc = Byte.TYPE;
        } else if (type2 == Boolean.class) {
            rc = Boolean.TYPE;
        } else if (type2 == Character.class) {
            rc = Character.TYPE;
        }
        return rc;
    }

    public static String getDefaultCharacterSet() {
        return Charset.defaultCharset().name();
    }

    public static String getPropertyName(Method method) {
        String propertyName = method.getName();
        if (propertyName.startsWith("set") && method.getParameterCount() == 1) {
            propertyName = StringHelper.decapitalize(propertyName.substring(3));
        }
        return propertyName;
    }

    public static boolean hasAnnotation(Annotation[] annotations2, Class<?> type2) {
        for (Annotation annotation : annotations2) {
            if (!type2.isInstance(annotation)) continue;
            return true;
        }
        return false;
    }

    public static <A extends Annotation> A getAnnotation(Object instance, Class<A> type2) {
        return instance.getClass().getAnnotation(type2);
    }

    public static <T> T cast(Class<T> toType, Object value) {
        Class<?> newType;
        if (toType == Boolean.TYPE) {
            return (T)ObjectHelper.cast(Boolean.class, value);
        }
        if (toType.isPrimitive() && (newType = ObjectHelper.convertPrimitiveTypeToWrapperType(toType)) != toType) {
            return (T)ObjectHelper.cast(newType, value);
        }
        try {
            return toType.cast(value);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Failed to convert: " + String.valueOf(value) + " to type: " + toType.getName() + " due to: " + String.valueOf(e), e);
        }
    }

    public static boolean hasDefaultPublicNoArgConstructor(Class<?> type2) {
        for (Constructor<?> ctr : type2.getConstructors()) {
            if (ctr.getParameterCount() != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDefaultNoArgConstructor(Class<?> type2) {
        if (ObjectHelper.hasDefaultPublicNoArgConstructor(type2)) {
            return true;
        }
        for (Constructor<?> ctr : type2.getDeclaredConstructors()) {
            if (Modifier.isPrivate(ctr.getModifiers()) || ctr.getParameterCount() != 0) continue;
            return true;
        }
        return false;
    }

    public static Object type(Object bean) {
        return bean != null ? bean.getClass() : null;
    }

    public static boolean evaluateValuePredicate(Object value) {
        if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            return booleanValue;
        }
        if (value instanceof String) {
            String str = (String)value;
            return ObjectHelper.evaluateString(str);
        }
        if (value instanceof NodeList) {
            return ObjectHelper.evaluateNodeList(value);
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return !collection.isEmpty();
        }
        return value != null;
    }

    private static boolean evaluateString(String value) {
        String str = value.trim();
        if (str.isEmpty()) {
            return false;
        }
        if ("true".equalsIgnoreCase(str)) {
            return true;
        }
        return !"false".equalsIgnoreCase(str);
    }

    private static boolean evaluateNodeList(Object value) {
        Node node;
        if (value instanceof Node && (node = (Node)value).hasAttributes()) {
            return true;
        }
        NodeList list = (NodeList)value;
        return list.getLength() > 0;
    }

    public static Iterable<Throwable> createExceptionIterable(Throwable exception) {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        for (Throwable current = exception; current != null; current = current.getCause()) {
            throwables.add(current);
        }
        Collections.reverse(throwables);
        return throwables;
    }

    public static Iterator<Throwable> createExceptionIterator(Throwable exception) {
        return ObjectHelper.createExceptionIterable(exception).iterator();
    }

    public static <T> T getException(Class<T> type2, Throwable exception) {
        if (exception == null) {
            return null;
        }
        for (Throwable throwable : exception.getSuppressed()) {
            if (!type2.isInstance(throwable)) continue;
            return type2.cast(throwable);
        }
        for (Throwable throwable : ObjectHelper.createExceptionIterable(exception)) {
            if (!type2.isInstance(throwable)) continue;
            return type2.cast(throwable);
        }
        return null;
    }

    public static String getIdentityHashCode(Object object) {
        return "0x" + Integer.toHexString(System.identityHashCode(object));
    }

    public static String lookupConstantFieldValue(Class<?> clazz, String name) {
        if (clazz == null) {
            return null;
        }
        if (name.startsWith(".")) {
            name = name.substring(1);
        }
        for (Field field : clazz.getFields()) {
            if (!field.getName().equals(name)) continue;
            try {
                Object v = field.get(null);
                return v.toString();
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return null;
    }

    public static boolean isNaN(Object value) {
        return value instanceof Float && ((Float)value).isNaN() || value instanceof Double && ((Double)value).isNaN();
    }

    public static List<Object> asList(Object[] objects) {
        return objects != null ? Arrays.asList(objects) : Collections.emptyList();
    }

    public static void addListByIndex(List<Object> list, int idx, Object value) {
        if (idx < list.size()) {
            list.set(idx, value);
        } else if (idx == list.size()) {
            list.add(value);
        } else {
            if (list instanceof ArrayList) {
                ((ArrayList)list).ensureCapacity(idx + 1);
            }
            while (list.size() < idx) {
                list.add(null);
            }
            list.add(idx, value);
        }
    }

    public static boolean isBoolean(String str) {
        return "true".equalsIgnoreCase(str) || "false".equalsIgnoreCase(str);
    }

    private static Logger logger() {
        return Holder.LOG;
    }

    private static final class Holder {
        static final Logger LOG = LoggerFactory.getLogger(Holder.class);

        private Holder() {
        }
    }
}

