/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi;

import java.math.BigInteger;
import java.util.List;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeEncoder;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.StaticArray;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Uint;

public class DefaultFunctionEncoder
extends FunctionEncoder {
    @Override
    public String encodeFunction(Function function) {
        List<Type> parameters2 = function.getInputParameters();
        String methodSignature = DefaultFunctionEncoder.buildMethodSignature(function.getName(), parameters2);
        String methodId = DefaultFunctionEncoder.buildMethodId(methodSignature);
        StringBuilder result2 = new StringBuilder();
        result2.append(methodId);
        return DefaultFunctionEncoder.encodeParameters(parameters2, result2);
    }

    @Override
    public String encodeParameters(List<Type> parameters2) {
        return DefaultFunctionEncoder.encodeParameters(parameters2, new StringBuilder());
    }

    private static String encodeParameters(List<Type> parameters2, StringBuilder result2) {
        int dynamicDataOffset = DefaultFunctionEncoder.getLength(parameters2) * 32;
        StringBuilder dynamicData = new StringBuilder();
        for (Type parameter : parameters2) {
            String encodedValue = TypeEncoder.encode(parameter);
            if (TypeEncoder.isDynamic(parameter)) {
                String encodedDataOffset = TypeEncoder.encodeNumeric(new Uint(BigInteger.valueOf(dynamicDataOffset)));
                result2.append(encodedDataOffset);
                dynamicData.append(encodedValue);
                dynamicDataOffset += encodedValue.length() >> 1;
                continue;
            }
            result2.append(encodedValue);
        }
        result2.append((CharSequence)dynamicData);
        return result2.toString();
    }

    private static int getLength(List<Type> parameters2) {
        int count = 0;
        for (Type type2 : parameters2) {
            if (type2 instanceof StaticArray) {
                count += ((StaticArray)type2).getValue().size();
                continue;
            }
            ++count;
        }
        return count;
    }
}

