/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Array;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Bytes;
import org.web3j.abi.datatypes.BytesType;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.NumericType;
import org.web3j.abi.datatypes.StaticArray;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Ufixed;
import org.web3j.abi.datatypes.Uint;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.primitive.PrimitiveType;
import org.web3j.utils.Numeric;

public class TypeEncoder {
    private TypeEncoder() {
    }

    static boolean isDynamic(Type parameter) {
        return parameter instanceof DynamicBytes || parameter instanceof Utf8String || parameter instanceof DynamicArray;
    }

    public static String encode(Type parameter) {
        if (parameter instanceof NumericType) {
            return TypeEncoder.encodeNumeric((NumericType)parameter);
        }
        if (parameter instanceof Address) {
            return TypeEncoder.encodeAddress((Address)parameter);
        }
        if (parameter instanceof Bool) {
            return TypeEncoder.encodeBool((Bool)parameter);
        }
        if (parameter instanceof Bytes) {
            return TypeEncoder.encodeBytes((Bytes)parameter);
        }
        if (parameter instanceof DynamicBytes) {
            return TypeEncoder.encodeDynamicBytes((DynamicBytes)parameter);
        }
        if (parameter instanceof Utf8String) {
            return TypeEncoder.encodeString((Utf8String)parameter);
        }
        if (parameter instanceof StaticArray) {
            return TypeEncoder.encodeArrayValues((StaticArray)parameter);
        }
        if (parameter instanceof DynamicArray) {
            return TypeEncoder.encodeDynamicArray((DynamicArray)parameter);
        }
        if (parameter instanceof PrimitiveType) {
            return TypeEncoder.encode(((PrimitiveType)parameter).toSolidityType());
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + parameter.getClass());
    }

    static String encodeAddress(Address address) {
        return TypeEncoder.encodeNumeric(address.toUint());
    }

    static String encodeNumeric(NumericType numericType) {
        byte[] rawValue = TypeEncoder.toByteArray(numericType);
        byte paddingValue = TypeEncoder.getPaddingValue(numericType);
        byte[] paddedRawValue = new byte[32];
        if (paddingValue != 0) {
            for (int i = 0; i < paddedRawValue.length; ++i) {
                paddedRawValue[i] = paddingValue;
            }
        }
        System.arraycopy(rawValue, 0, paddedRawValue, 32 - rawValue.length, rawValue.length);
        return Numeric.toHexStringNoPrefix(paddedRawValue);
    }

    private static byte getPaddingValue(NumericType numericType) {
        if (numericType.getValue().signum() == -1) {
            return -1;
        }
        return 0;
    }

    private static byte[] toByteArray(NumericType numericType) {
        BigInteger value = numericType.getValue();
        if ((numericType instanceof Ufixed || numericType instanceof Uint) && value.bitLength() == 256) {
            byte[] byteArray = new byte[32];
            System.arraycopy(value.toByteArray(), 1, byteArray, 0, 32);
            return byteArray;
        }
        return value.toByteArray();
    }

    static String encodeBool(Bool value) {
        byte[] rawValue = new byte[32];
        if (value.getValue().booleanValue()) {
            rawValue[rawValue.length - 1] = 1;
        }
        return Numeric.toHexStringNoPrefix(rawValue);
    }

    static String encodeBytes(BytesType bytesType) {
        byte[] dest;
        byte[] value = bytesType.getValue();
        int length = value.length;
        int mod = length % 32;
        if (mod != 0) {
            int padding = 32 - mod;
            dest = new byte[length + padding];
            System.arraycopy(value, 0, dest, 0, length);
        } else {
            dest = value;
        }
        return Numeric.toHexStringNoPrefix(dest);
    }

    static String encodeDynamicBytes(DynamicBytes dynamicBytes) {
        int size = dynamicBytes.getValue().length;
        String encodedLength = TypeEncoder.encode(new Uint(BigInteger.valueOf(size)));
        String encodedValue = TypeEncoder.encodeBytes(dynamicBytes);
        StringBuilder result2 = new StringBuilder();
        result2.append(encodedLength);
        result2.append(encodedValue);
        return result2.toString();
    }

    static String encodeString(Utf8String string) {
        byte[] utfEncoded = string.getValue().getBytes(StandardCharsets.UTF_8);
        return TypeEncoder.encodeDynamicBytes(new DynamicBytes(utfEncoded));
    }

    static <T extends Type> String encodeArrayValues(Array<T> value) {
        StringBuilder result2 = new StringBuilder();
        Iterator iterator2 = value.getValue().iterator();
        while (iterator2.hasNext()) {
            Type type2 = (Type)iterator2.next();
            result2.append(TypeEncoder.encode(type2));
        }
        return result2.toString();
    }

    static <T extends Type> String encodeDynamicArray(DynamicArray<T> value) {
        int size = value.getValue().size();
        String encodedLength = TypeEncoder.encode(new Uint(BigInteger.valueOf(size)));
        String valuesOffsets = TypeEncoder.encodeArrayValuesOffsets(value);
        String encodedValues = TypeEncoder.encodeArrayValues(value);
        StringBuilder result2 = new StringBuilder();
        result2.append(encodedLength);
        result2.append(valuesOffsets);
        result2.append(encodedValues);
        return result2.toString();
    }

    private static <T extends Type> String encodeArrayValuesOffsets(DynamicArray<T> value) {
        boolean arrayOfString;
        StringBuilder result2 = new StringBuilder();
        boolean arrayOfBytes = !value.getValue().isEmpty() && value.getValue().get(0) instanceof DynamicBytes;
        boolean bl = arrayOfString = !value.getValue().isEmpty() && value.getValue().get(0) instanceof Utf8String;
        if (arrayOfBytes || arrayOfString) {
            long offset = 0L;
            for (int i = 0; i < value.getValue().size(); ++i) {
                if (i == 0) {
                    offset = value.getValue().size() * 32;
                } else {
                    int bytesLength = arrayOfBytes ? ((byte[])((Type)value.getValue().get(i - 1)).getValue()).length : ((String)((Type)value.getValue().get(i - 1)).getValue()).length();
                    int numberOfWords = (bytesLength + 32 - 1) / 32;
                    int totalBytesLength = numberOfWords * 32;
                    offset += (long)(totalBytesLength + 32);
                }
                result2.append(Numeric.toHexStringNoPrefix(Numeric.toBytesPadded(new BigInteger(Long.toString(offset)), 32)));
            }
        }
        return result2.toString();
    }
}

