/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.quorum.tx;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.quorum.PrivacyFlag;
import org.web3j.quorum.Quorum;
import org.web3j.quorum.enclave.Enclave;
import org.web3j.quorum.enclave.SendResponse;
import org.web3j.quorum.tx.util.Base64Kt;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.tx.RawTransactionManager;
import org.web3j.utils.Numeric;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0002\u0010\fB=\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fBK\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0002\u0010\u0011Bm\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0017J\u001c\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\t2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0016J$\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\t2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/web3j/quorum/tx/QuorumTransactionManager;", "Lorg/web3j/tx/RawTransactionManager;", "web3j", "Lorg/web3j/quorum/Quorum;", "enclave", "Lorg/web3j/quorum/enclave/Enclave;", "credentials", "Lorg/web3j/crypto/Credentials;", "publicKey", "", "privateFor", "", "(Lorg/web3j/quorum/Quorum;Lorg/web3j/quorum/enclave/Enclave;Lorg/web3j/crypto/Credentials;Ljava/lang/String;Ljava/util/List;)V", "privacyFlag", "Lorg/web3j/quorum/PrivacyFlag;", "(Lorg/web3j/quorum/Quorum;Lorg/web3j/quorum/enclave/Enclave;Lorg/web3j/crypto/Credentials;Ljava/lang/String;Ljava/util/List;Lorg/web3j/quorum/PrivacyFlag;)V", "mandatoryFor", "(Lorg/web3j/quorum/Quorum;Lorg/web3j/quorum/enclave/Enclave;Lorg/web3j/crypto/Credentials;Ljava/lang/String;Ljava/util/List;Lorg/web3j/quorum/PrivacyFlag;Ljava/util/List;)V", "chainId", "", "attempts", "", "sleepDuration", "(Lorg/web3j/quorum/Quorum;Lorg/web3j/quorum/enclave/Enclave;Lorg/web3j/crypto/Credentials;Ljava/lang/String;Ljava/util/List;Lorg/web3j/quorum/PrivacyFlag;Ljava/util/List;JIJ)V", "sendRaw", "Lorg/web3j/protocol/core/methods/response/EthSendTransaction;", "signedTx", "to", "setPrivate", "", "message", "sign", "rawTransaction", "Lorg/web3j/crypto/RawTransaction;", "signAndSend", "storeRawRequest", "Lorg/web3j/quorum/enclave/SendResponse;", "payload", "from", "web3j-quorum"})
public class QuorumTransactionManager
extends RawTransactionManager {
    @NotNull
    private final Quorum web3j;
    @NotNull
    private final Enclave enclave;
    @NotNull
    private final Credentials credentials;
    @NotNull
    private final String publicKey;
    @NotNull
    private List<String> privateFor;
    @Nullable
    private PrivacyFlag privacyFlag;
    @Nullable
    private List<String> mandatoryFor;

    public QuorumTransactionManager(@NotNull Quorum web3j, @NotNull Enclave enclave, @NotNull Credentials credentials, @NotNull String publicKey, @NotNull List<String> privateFor, @Nullable PrivacyFlag privacyFlag, @Nullable List<String> mandatoryFor, long chainId, int attempts, long sleepDuration) {
        Intrinsics.checkNotNullParameter(web3j, "web3j");
        Intrinsics.checkNotNullParameter(enclave, "enclave");
        Intrinsics.checkNotNullParameter(credentials, "credentials");
        Intrinsics.checkNotNullParameter(publicKey, "publicKey");
        Intrinsics.checkNotNullParameter(privateFor, "privateFor");
        super(web3j, credentials, chainId, attempts, sleepDuration);
        this.web3j = web3j;
        this.enclave = enclave;
        this.credentials = credentials;
        this.publicKey = publicKey;
        this.privateFor = privateFor;
        this.privacyFlag = privacyFlag;
        this.mandatoryFor = mandatoryFor;
    }

    public /* synthetic */ QuorumTransactionManager(Quorum quorum, Enclave enclave, Credentials credentials, String string, List list, PrivacyFlag privacyFlag, List list2, long l, int n, long l2, int n2, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n2 & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 0x80) != 0) {
            l = -1L;
        }
        if ((n2 & 0x100) != 0) {
            n = 40;
        }
        if ((n2 & 0x200) != 0) {
            l2 = 15000L;
        }
        this(quorum, enclave, credentials, string, list, privacyFlag, list2, l, n, l2);
    }

    public QuorumTransactionManager(@NotNull Quorum web3j, @NotNull Enclave enclave, @NotNull Credentials credentials, @NotNull String publicKey, @NotNull List<String> privateFor) {
        Intrinsics.checkNotNullParameter(web3j, "web3j");
        Intrinsics.checkNotNullParameter(enclave, "enclave");
        Intrinsics.checkNotNullParameter(credentials, "credentials");
        Intrinsics.checkNotNullParameter(publicKey, "publicKey");
        Intrinsics.checkNotNullParameter(privateFor, "privateFor");
        this(web3j, enclave, credentials, publicKey, privateFor, null, null, 0L, 0, 0L, 896, null);
    }

    public QuorumTransactionManager(@NotNull Quorum web3j, @NotNull Enclave enclave, @NotNull Credentials credentials, @NotNull String publicKey, @NotNull List<String> privateFor, @NotNull PrivacyFlag privacyFlag) {
        Intrinsics.checkNotNullParameter(web3j, "web3j");
        Intrinsics.checkNotNullParameter(enclave, "enclave");
        Intrinsics.checkNotNullParameter(credentials, "credentials");
        Intrinsics.checkNotNullParameter(publicKey, "publicKey");
        Intrinsics.checkNotNullParameter(privateFor, "privateFor");
        Intrinsics.checkNotNullParameter((Object)privacyFlag, "privacyFlag");
        this(web3j, enclave, credentials, publicKey, privateFor, privacyFlag, null, 0L, 0, 0L, 896, null);
    }

    public QuorumTransactionManager(@NotNull Quorum web3j, @NotNull Enclave enclave, @NotNull Credentials credentials, @NotNull String publicKey, @NotNull List<String> privateFor, @NotNull PrivacyFlag privacyFlag, @NotNull List<String> mandatoryFor) {
        Intrinsics.checkNotNullParameter(web3j, "web3j");
        Intrinsics.checkNotNullParameter(enclave, "enclave");
        Intrinsics.checkNotNullParameter(credentials, "credentials");
        Intrinsics.checkNotNullParameter(publicKey, "publicKey");
        Intrinsics.checkNotNullParameter(privateFor, "privateFor");
        Intrinsics.checkNotNullParameter((Object)privacyFlag, "privacyFlag");
        Intrinsics.checkNotNullParameter(mandatoryFor, "mandatoryFor");
        this(web3j, enclave, credentials, publicKey, privateFor, privacyFlag, mandatoryFor, -1L, 0, 0L, 768, null);
    }

    @NotNull
    public final SendResponse storeRawRequest(@NotNull String payload, @NotNull String from, @NotNull List<String> to) {
        Intrinsics.checkNotNullParameter(payload, "payload");
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        byte[] byArray = Numeric.hexStringToByteArray(payload);
        Intrinsics.checkNotNullExpressionValue(byArray, "hexStringToByteArray(payload)");
        String payloadBase64 = Base64Kt.encode(byArray);
        return this.enclave.storeRawRequest(payloadBase64, from, to);
    }

    @NotNull
    public final EthSendTransaction sendRaw(@NotNull String signedTx, @NotNull List<String> to) {
        Intrinsics.checkNotNullParameter(signedTx, "signedTx");
        Intrinsics.checkNotNullParameter(to, "to");
        return this.enclave.sendRawRequest(signedTx, to, this.privacyFlag, this.mandatoryFor);
    }

    @Override
    @NotNull
    public String sign(@NotNull RawTransaction rawTransaction) {
        Intrinsics.checkNotNullParameter(rawTransaction, "rawTransaction");
        byte[] signedMessage = TransactionEncoder.signMessage(rawTransaction, this.credentials);
        if (!((Collection)this.privateFor).isEmpty()) {
            Intrinsics.checkNotNullExpressionValue(signedMessage, "signedMessage");
            signedMessage = this.setPrivate(signedMessage);
        }
        String string = Numeric.toHexString(signedMessage);
        Intrinsics.checkNotNullExpressionValue(string, "toHexString(signedMessage)");
        return string;
    }

    @Override
    @NotNull
    public EthSendTransaction signAndSend(@NotNull RawTransaction rawTransaction) {
        Intrinsics.checkNotNullParameter(rawTransaction, "rawTransaction");
        byte[] signedMessage = null;
        if (!((Collection)this.privateFor).isEmpty()) {
            byte[] byArray = Numeric.hexStringToByteArray(rawTransaction.getData());
            Intrinsics.checkNotNullExpressionValue(byArray, "hexStringToByteArray(rawTransaction.data)");
            String base64Encoded = Base64Kt.encode(byArray);
            SendResponse response = this.enclave.storeRawRequest(base64Encoded, this.publicKey, this.privateFor);
            String responseDecoded = Numeric.toHexString(Base64Kt.decode(response.getKey()));
            RawTransaction privateTransaction = RawTransaction.createTransaction(rawTransaction.getNonce(), rawTransaction.getGasPrice(), rawTransaction.getGasLimit(), rawTransaction.getTo(), rawTransaction.getValue(), responseDecoded);
            byte[] privateMessage = TransactionEncoder.signMessage(privateTransaction, this.credentials);
            Intrinsics.checkNotNullExpressionValue(privateMessage, "privateMessage");
            signedMessage = this.setPrivate(privateMessage);
        } else {
            byte[] byArray = TransactionEncoder.signMessage(rawTransaction, this.credentials);
            Intrinsics.checkNotNullExpressionValue(byArray, "signMessage(rawTransaction, credentials)");
            signedMessage = byArray;
        }
        String hexValue = Numeric.toHexString(signedMessage);
        Intrinsics.checkNotNullExpressionValue(hexValue, "hexValue");
        return this.enclave.sendRawRequest(hexValue, this.privateFor, this.privacyFlag, this.mandatoryFor);
    }

    private final byte[] setPrivate(byte[] message) {
        RlpType vField;
        int rlpListSize;
        RlpType rlpList;
        byte[] result2 = message;
        RlpList rlpWrappingList = RlpDecoder.decode(message);
        if (rlpWrappingList != null && !rlpWrappingList.getValues().isEmpty() && (rlpList = rlpWrappingList.getValues().get(0)) instanceof RlpList && (rlpListSize = ((RlpList)rlpList).getValues().size()) > 3 && (vField = ((RlpList)rlpList).getValues().get(rlpListSize - 3)) instanceof RlpString && 1 == ((RlpString)vField).getBytes().length) {
            ((RlpString)vField).getBytes()[0] = ((RlpString)vField).getBytes()[0] == 28 ? 38 : 37;
            byte[] byArray = RlpEncoder.encode(rlpList);
            Intrinsics.checkNotNullExpressionValue(byArray, "encode(rlpList)");
            result2 = byArray;
        }
        return result2;
    }
}

