/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.utils;

import java.io.IOException;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

public class RevertReasonExtractor {
    public static final String MISSING_REASON = "N/A";

    public static String extractRevertReason(TransactionReceipt transactionReceipt, String data2, Web3j web3j, Boolean revertReasonCallEnabled) throws IOException {
        String revertReason;
        if (transactionReceipt.getRevertReason() != null) {
            return transactionReceipt.getRevertReason();
        }
        if (revertReasonCallEnabled.booleanValue() && (revertReason = RevertReasonExtractor.retrieveRevertReason(transactionReceipt, data2, web3j)) != null) {
            transactionReceipt.setRevertReason(revertReason);
            return revertReason;
        }
        return MISSING_REASON;
    }

    public static String retrieveRevertReason(TransactionReceipt transactionReceipt, String data2, Web3j web3j) throws IOException {
        if (transactionReceipt.getBlockNumber() == null) {
            return null;
        }
        return web3j.ethCall(Transaction.createEthCallTransaction(transactionReceipt.getFrom(), transactionReceipt.getTo(), data2), DefaultBlockParameter.valueOf(transactionReceipt.getBlockNumber())).send().getRevertReason();
    }
}

