/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.annotations.Nullable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.operators.flowable.FlowableFromIterable;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableFlattenIterable<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends Iterable<? extends R>> mapper;
    final int prefetch;

    public FlowableFlattenIterable(Flowable<T> source2, Function<? super T, ? extends Iterable<? extends R>> mapper, int prefetch) {
        super(source2);
        this.mapper = mapper;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribeActual(Subscriber<? super R> s) {
        if (this.source instanceof Callable) {
            Iterator<? extends R> it;
            Object v;
            try {
                v = ((Callable)((Object)this.source)).call();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                EmptySubscription.error(ex, s);
                return;
            }
            if (v == null) {
                EmptySubscription.complete(s);
                return;
            }
            try {
                Iterable<R> iterable = this.mapper.apply(v);
                it = iterable.iterator();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                EmptySubscription.error(ex, s);
                return;
            }
            FlowableFromIterable.subscribe(s, it);
            return;
        }
        this.source.subscribe(new FlattenIterableSubscriber<T, R>(s, this.mapper, this.prefetch));
    }

    static final class FlattenIterableSubscriber<T, R>
    extends BasicIntQueueSubscription<R>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -3096000382929934955L;
        final Subscriber<? super R> downstream;
        final Function<? super T, ? extends Iterable<? extends R>> mapper;
        final int prefetch;
        final int limit;
        final AtomicLong requested;
        Subscription upstream;
        SimpleQueue<T> queue;
        volatile boolean done;
        volatile boolean cancelled;
        final AtomicReference<Throwable> error;
        Iterator<? extends R> current;
        int consumed;
        int fusionMode;

        FlattenIterableSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends Iterable<? extends R>> mapper, int prefetch) {
            this.downstream = actual;
            this.mapper = mapper;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.error = new AtomicReference();
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                if (s instanceof QueueSubscription) {
                    QueueSubscription qs = (QueueSubscription)s;
                    int m = qs.requestFusion(3);
                    if (m == 1) {
                        this.fusionMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.downstream.onSubscribe(this);
                        return;
                    }
                    if (m == 2) {
                        this.fusionMode = m;
                        this.queue = qs;
                        this.downstream.onSubscribe(this);
                        s.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                this.downstream.onSubscribe(this);
                s.request(this.prefetch);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.fusionMode == 0 && !this.queue.offer(t)) {
                this.onError(new MissingBackpressureException("Queue is full?!"));
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t) {
            if (!this.done && ExceptionHelper.addThrowable(this.error, t)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            Subscriber<R> a = this.downstream;
            SimpleQueue<T> q = this.queue;
            boolean replenish = this.fusionMode != 1;
            int missed = 1;
            Iterator<R> it = this.current;
            while (true) {
                if (it == null) {
                    boolean empty2;
                    T t;
                    boolean d = this.done;
                    try {
                        t = q.poll();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.upstream.cancel();
                        ExceptionHelper.addThrowable(this.error, ex);
                        ex = ExceptionHelper.terminate(this.error);
                        this.current = null;
                        q.clear();
                        a.onError(ex);
                        return;
                    }
                    boolean bl = empty2 = t == null;
                    if (this.checkTerminated(d, empty2, a, q)) {
                        return;
                    }
                    if (t != null) {
                        boolean b;
                        try {
                            Iterable<R> iterable = this.mapper.apply(t);
                            it = iterable.iterator();
                            b = it.hasNext();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.upstream.cancel();
                            ExceptionHelper.addThrowable(this.error, ex);
                            ex = ExceptionHelper.terminate(this.error);
                            a.onError(ex);
                            return;
                        }
                        if (!b) {
                            it = null;
                            this.consumedOne(replenish);
                            continue;
                        }
                        this.current = it;
                    }
                }
                if (it != null) {
                    long e;
                    long r = this.requested.get();
                    for (e = 0L; e != r; ++e) {
                        R v;
                        if (this.checkTerminated(this.done, false, a, q)) {
                            return;
                        }
                        try {
                            v = ObjectHelper.requireNonNull(it.next(), "The iterator returned a null value");
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.current = null;
                            this.upstream.cancel();
                            ExceptionHelper.addThrowable(this.error, ex);
                            ex = ExceptionHelper.terminate(this.error);
                            a.onError(ex);
                            return;
                        }
                        a.onNext(v);
                        if (this.checkTerminated(this.done, false, a, q)) {
                            return;
                        }
                        try {
                            boolean b = it.hasNext();
                            continue;
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.current = null;
                            this.upstream.cancel();
                            ExceptionHelper.addThrowable(this.error, ex);
                            ex = ExceptionHelper.terminate(this.error);
                            a.onError(ex);
                            return;
                        }
                    }
                    if (e == r) {
                        boolean empty3;
                        boolean d = this.done;
                        boolean bl = empty3 = q.isEmpty() && it == null;
                        if (this.checkTerminated(d, empty3, a, q)) {
                            return;
                        }
                    }
                    if (e != 0L && r != Long.MAX_VALUE) {
                        this.requested.addAndGet(-e);
                    }
                    if (it == null) continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        void consumedOne(boolean enabled) {
            if (enabled) {
                int c = this.consumed + 1;
                if (c == this.limit) {
                    this.consumed = 0;
                    this.upstream.request(c);
                } else {
                    this.consumed = c;
                }
            }
        }

        boolean checkTerminated(boolean d, boolean empty2, Subscriber<?> a, SimpleQueue<?> q) {
            if (this.cancelled) {
                this.current = null;
                q.clear();
                return true;
            }
            if (d) {
                Throwable ex = this.error.get();
                if (ex != null) {
                    ex = ExceptionHelper.terminate(this.error);
                    this.current = null;
                    q.clear();
                    a.onError(ex);
                    return true;
                }
                if (empty2) {
                    a.onComplete();
                    return true;
                }
            }
            return false;
        }

        @Override
        public void clear() {
            this.current = null;
            this.queue.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.current == null && this.queue.isEmpty();
        }

        @Override
        @Nullable
        public R poll() throws Exception {
            Iterator<R> it = this.current;
            while (it == null) {
                T v = this.queue.poll();
                if (v == null) {
                    return null;
                }
                it = this.mapper.apply(v).iterator();
                if (!it.hasNext()) {
                    it = null;
                    continue;
                }
                this.current = it;
                break;
            }
            R r = ObjectHelper.requireNonNull(it.next(), "The iterator returned a null value");
            if (!it.hasNext()) {
                this.current = null;
            }
            return r;
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 1) != 0 && this.fusionMode == 1) {
                return 1;
            }
            return 0;
        }
    }
}

